﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief       Cruiser 用デバッグ設定に関する API の宣言
 */

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/settings/system/settings_Common.h>

namespace nn { namespace settings { namespace system {

//!< SSL チェック無効化ホストの最大数
const size_t AllowedSslHostCountMax = 8;

//!< SSL チェック無効化ホストを表す構造体です。
struct AllowedSslHost
{
    char name[256]; //!< ホスト名
};

//!< ホスト FS のマウントポイントを表す構造体です。
struct HostFsMountPoint
{
    char path[256]; //!< ファイルパス
};

//! @name Cruiser 用デバッグ設定関連 API
//! @{

/**
 * @brief       Web インスペクタを使用するか否かを表す値を返します。
 *
 * @return      Web インスペクタを使用するか否かを表す値です。
 */
bool UsesWebInspector() NN_NOEXCEPT;

/**
 * @brief       SSL チェック無効化ホストを取得します。
 *
 * @details     読み出し可能な値の最大数は AllowedSslHostCountMax 個です。
 *
 * @param[out]  outHosts                    SSL チェック無効化ホストを読み出すバッファ
 * @param[in]   count                       outHosts の数
 *
 * @return      読み出した SSL チェック無効化ホストの数を返します。
 *
 * @pre
 *              - outHosts != nullptr
 */
size_t GetAllowedSslHosts(AllowedSslHost outHosts[], size_t count) NN_NOEXCEPT;

/**
 * @brief       ホスト FS のマウントポイントを取得します。
 *
 * @param[out]  pOutValue                   マウントポイントを読み出すバッファ
 *
 * @pre
 *              - pOutValue != nullptr
 */
void GetHostFsMountPoint(HostFsMountPoint* pOutValue) NN_NOEXCEPT;

//! @}

}}} // nn::settings::system
