﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief       製品モデルに関する API の宣言
 */

#pragma once

#include <nn/nn_Macro.h>
#include <nn/settings/system/settings_Common.h>

namespace nn { namespace settings { namespace system {

//!< 製品モデルを表す列挙体です。
enum ProductModel
{
    ProductModel_Invalid = 0,  //!< 不正なモデル
    ProductModel_Nx = 1,       //!< NX
    ProductModel_NxCopper = 2, //!< Copper
    ProductModel_NxIowa = 3,   //!< Iowa
    ProductModel_NxHoag = 4,   //!< Hoag
};

//! @name 製品モデル関連 API
//! @{

/**
 * @brief       製品モデルを返します。
 *
 * @return      製品モデルです。
 */
ProductModel GetProductModel() NN_NOEXCEPT;

//! @}

}}} // nn::settings::system
