﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief       PCV 設定に関する API の宣言
 */

#pragma once

#include <nn/nn_Macro.h>
#include <nn/settings/system/settings_Common.h>

namespace nn { namespace settings { namespace system {

//! @name PCV 設定関連 API
//! @{

/**
 * @brief       外部 RTC のリセットが発生したか否かを表す値を返します。
 *
 * @return      外部 RTC のリセットが発生したか否かを表す値です。
 */
bool IsExternalRtcReset() NN_NOEXCEPT;

/**
 * @brief       外部 RTC のリセットが発生したか否かを表す値を設定します。
 *
 * @param[in]   isReset                     外部 RTC のリセットが発生したか否かを表す値
 */
void SetExternalRtcReset(bool isReset) NN_NOEXCEPT;

//! @}

}}} // nn::settings::system
