﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief       おすすめ削除に関するシステムアプリケーション向け設定 API の宣言
 */

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/settings/system/settings_Common.h>
#include <nn/util/util_BitFlagSet.h>

namespace nn { namespace settings { namespace system {

/**
 * @brief       おすすめ削除の制御フラグ定義です。
 */
struct DataDeletionFlag
{
    typedef ::nn::util::BitFlagSet<32, DataDeletionFlag>::Flag<0>
            Automatic;  //!< 自動削除の有効化
};

/**
 * @brief       おすすめ削除の制御フラグ集合を扱う型です。
 */
typedef ::nn::util::BitFlagSet<32, DataDeletionFlag> DataDeletionFlagSet;

/**
 * @brief       おすすめ削除の設定を表す構造体です。
 */
struct DataDeletionSettings
{
    DataDeletionFlagSet flags;  //!< 制御フラグ
    int32_t useCount;           //!< おすすめ削除を利用した回数
};

//! @name おすすめ削除関連 API
//! @{

/**
 * @brief       おすすめ削除の設定を取得します。
 *
 * @details     おすすめ削除の設定として指定されている値を取得します。
 *
 * @param[out]  pOutValue                   おすすめ削除の設定を読み出すバッファ
 *
 * @pre
 *              - pOutValue != nullptr
 */
void GetDataDeletionSettings(DataDeletionSettings* pOutValue) NN_NOEXCEPT;

/**
 * @brief       おすすめ削除の設定を変更します。
 *
 * @details     おすすめ削除の設定を指定された値に変更します。
 *
 * @param[in]   value                       おすすめ削除の設定
 */
void SetDataDeletionSettings(const DataDeletionSettings& value) NN_NOEXCEPT;

//! @}

}}} // nn::settings::system
