﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 *  @file
 *  @brief   スピーカーの生産時設定に関する API の宣言
 */

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Result.h>
#include <nn/settings/factory/settings_Result.h>

namespace nn { namespace settings { namespace factory {

/**
 * @brief       スピーカーのパラメータを表す構造体です。
 */
struct SpeakerParameter
{
    uint16_t version;                    //!< 較正値バージョン
    NN_PADDING2;
    NN_PADDING2;
    NN_PADDING2;
    NN_PADDING2;
    NN_PADDING2;
    NN_PADDING2;
    NN_PADDING2;
    NN_PADDING2;
    NN_PADDING2;
    NN_PADDING2;
    NN_PADDING2;
    NN_PADDING2;
    NN_PADDING2;
    NN_PADDING2;
    NN_PADDING2;
    NN_PADDING2;
    NN_PADDING2;
    uint16_t speakerHpf2A1;              //!< HPF2 a1
    uint16_t speakerHpf2A2;              //!< HPF2 a2
    uint16_t speakerHpf2H0;              //!< HPF2 h0
    uint16_t speakerEqInputVolume;       //!< EQ Input Volume
    uint16_t speakerEqOutputVolume;      //!< EQ Output Volume
    uint16_t speakerEqCtrl1;             //!< EQ 設定 1（ON/OFF, type）
    uint16_t speakerEqCtrl2;             //!< EQ 設定 2（path）
    uint16_t speakerDrcAgcCtrl2;         //!< DRC Pre/Post-Boost Gain
    uint16_t speakerDrcAgcCtrl3;         //!< DRC Limiter Level
    uint16_t speakerDrcAgcCtrl1;         //!< DRC Attack/Recovery Rate
    uint16_t speakerAnalogVolume;        //!< スピーカーのアナログボリューム値
    uint16_t headphoneAnalogVolume;      //!< ヘッドホンのアナログボリューム値
    uint16_t speakerDigitalVolumeMin;    //!< スピーカー出力時のデジタルボリュームの最小値
    uint16_t speakerDigitalVolumeMax;    //!< スピーカー出力時のデジタルボリュームの最大値
    uint16_t headphoneDigitalVolumeMin;  //!< ヘッドホン出力時のデジタルボリュームの最小値
    uint16_t headphoneDigitalVolumeMax;  //!< ヘッドホン出力時のデジタルボリュームの最大値
    uint16_t micFixedGain;               //!< マイクの固定ゲイン値
    uint16_t micVariableVolumeMin;       //!< マイクの可変ボリュームの最小値
    uint16_t micVariableVolumeMax;       //!< マイクの可変ボリュームの最大値
    NN_PADDING2;
    NN_PADDING2;
    NN_PADDING2;
    NN_PADDING2;
    NN_PADDING2;
    NN_PADDING2;
    NN_PADDING2;
    NN_PADDING2;
};

/**
 * @brief       スピーカーのパラメータを取得します。
 *
 * @param[out]  pOutValue                       スピーカーのパラメータを読み出すバッファ
 *
 * @retresult
 * @handleresult{nn::settings::factory::ResultCalibrationDataFileSystemCorrupted}
 * @handleresult{nn::settings::factory::ResultCalibrationDataCrcError}
 * @endretresult
 *
 * @pre
 *              - pOutValue != nullptr
 */
::nn::Result GetSpeakerParameter(SpeakerParameter* pOutValue) NN_NOEXCEPT;

}}} // nn::settings::factory
