﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief       ブート設定に関する設定変更 API の宣言
 */

#pragma once

#include <nn/nn_Macro.h>
#include <nn/ncm/ncm_ProgramId.h>

namespace nn { namespace settings { namespace factory {

/**
 * @brief       初回ブートするシステムアプレットの ProgramId を設定します。
 *
 * @param[in]   value                       システムアプレットの ProgramId
 */
void SetInitialSystemAppletProgramId(const ::nn::ncm::ProgramId& value
                                     ) NN_NOEXCEPT;

/**
 * @brief       初回ブートするオーバーレイ表示の ProgramId を設定します。
 *
 * @param[in]   value                       オーバーレイ表示の ProgramId
 */
void SetOverlayDispProgramId(const ::nn::ncm::ProgramId& value) NN_NOEXCEPT;

}}} // namespace nn::settings::factory
