﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief PSM ライブラリの API 宣言。
 */

#pragma once

#include <nn/nn_Macro.h>

namespace nn { namespace psm {

/**
 * @brief      PSM ライブラリを初期化します。
 * @post
 *  - PSM ライブラリが初期化済の状態である
 * @details    PSM ライブラリを初期化します。
 */
void Initialize() NN_NOEXCEPT;

/**
 * @brief      PSM ライブラリを終了します。
 * @post
 *  - PSM ライブラリが初期化前の状態である
 * @details    PSM ライブラリを終了します。
 */
void Finalize() NN_NOEXCEPT;

}} // namespace nn::psm
