﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
    @file
*/

#pragma once

namespace nn  {
namespace psc {

/**
    @brief PM Module Id's for NX platform.
*/
enum PmModuleId
{
    // When using SF thread for event handling
    // 1 and 2 can't be used as event tags
    // see confluence for details...
    PmModuleId_Reserved0        = 0,
    PmModuleId_Reserved1        = 1,
    PmModuleId_Reserved2        = 2,

    // Modification rules for compatibility:
    //  1. Assign value explicitly
    //  2. Do not change values for existing ids without agreement with the owner of the id

    PmModuleId_Socket           = 3,        //!< Networking
    PmModuleId_Usb              = 4,        //!< USB Controller
    PmModuleId_Eth              = 5,        //!< Ethernet Controller
    PmModuleId_Fgm              = 6,        //!< Frequence Governor Module
    PmModuleId_PcvClock         = 7,        //!< Power/Clock/Voltage Controller : Clock controller part
    PmModuleId_PcvVoltage       = 8,        //!< Power/Clock/Voltage Controller : Regulator controller part
    PmModuleId_Gpio             = 9,        //!< GPIO Controller
    PmModuleId_Pinmux           = 10,       //!< Pinmux Controller
    PmModuleId_Uart             = 11,       //!< UART controller
    PmModuleId_I2c              = 12,       //!< I2C controller
    PmModuleId_I2cPowerBus      = 13,       //!< I2C controller: Power bus (PMIC) part
    PmModuleId_Spi              = 14,       //!< SPI controller
    PmModuleId_Pwm              = 15,       //!< PWM controller
    PmModuleId_Psm              = 16,       //!< Power Supply Manager
    PmModuleId_Tc               = 17,       //!< Thermal Coordinator
    PmModuleId_Omm              = 18,       //!< Operating Mode Manager
    PmModuleId_Pcie             = 19,       //!< PCIe controller
    PmModuleId_Lbl              = 20,       //!< LCD Back light controller
    PmModuleId_Display          = 21,       //!< Display services and drivers
    PmModuleId_Multimedia       = 22,       //!< Multimedia service and drivers

    PmModuleId_Hid              = 24,       //!< HID service and drivers
    PmModuleId_SocketWlan       = 25,       //!< Wlan Socket shim
    PmModuleId_Wlan             = 26,       //!< Wlan driver
    PmModuleId_Fs               = 27,       //!< Filesystems
    PmModuleId_Audio            = 28,       //!< Audio service and drivers
    PmModuleId_Tm               = 29,       //!< Target Manager
    PmModuleId_TmHostIo         = 30,       //!< Target Manager : Host IO controller part
    PmModuleId_Bluetooth        = 31,       //!< Bluetooth
    PmModuleId_Bpc              = 32,       //!< Board Power Control
    PmModuleId_Fan              = 33,       //!< Fan controller
    PmModuleId_Pcm              = 34,       //!< Power consumption monitor
    PmModuleId_Nfc              = 35,       //!< NFC service
    PmModuleId_Apm              = 36,       //!< Application Performance Manager
    PmModuleId_Btm              = 37,       //!< Bluetooth Manager
    PmModuleId_Nifm             = 38,       //!< Network Interface Manager
    PmModuleId_GpioLow          = 39,       //!< GPIO Controller: Low part (only depended by pinmux)
    PmModuleId_Npns             = 40,       //!< NPNS service
    PmModuleId_Lm               = 41,       //!< Log Manager
    PmModuleId_Bcat             = 42,       //!< Background Contents Asymmetric sync delivery and Transmission
    PmModuleId_Time             = 43,       //!< Time service
    PmModuleId_Pctl             = 44,       //!< Parental control service
    PmModuleId_Erpt             = 45,       //!< Error report service
    PmModuleId_Eupld            = 46,       //!< Error report upload service
    PmModuleId_Friends          = 47,       //!< Friends service
    PmModuleId_Bgtc             = 48,       //!< BackGround Task Coordinator
    PmModuleId_Account          = 49,       //!< Account service
    PmModuleId_Sasbus           = 50,       //!< Six Axis Sensor Bus
    PmModuleId_Ntc              = 51,       //!< NTC(Network Time Correction) service
    PmModuleId_Idle             = 52,       //!< Idle state manager
    PmModuleId_Tcap             = 53,       //!< Thermal Coordinator Advanced Policy
    PmModuleId_PsmLow           = 54,       //!< Power Supply Manager Low
    PmModuleId_Ndd              = 55,       //!< Neighbor Device Detection

    PmModuleId_NvHost           = 101,      //!< Host1x controller driver in nvservices
    PmModuleId_NvDbgSvc         = 105,      //!< For misc modules in nvdbgsvc process

    // Special modules
    PmModuleId_Spsm             = 127,       //!< SPSM (depends all other exist modules)
};

}}


