﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief      psc モジュール用の、ログを出力する API の宣言です。
*/

#include <nn/nn_Common.h>
#include <nn/diag/detail/diag_DetailStructuredSdkLog.h>

#define NN_DETAIL_PSC_TRACE(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(psc, Trace, 0, ##__VA_ARGS__)
#define NN_DETAIL_PSC_TRACE_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(psc, Trace, 1, ##__VA_ARGS__)
#define NN_DETAIL_PSC_TRACE_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(psc, Trace, 2, ##__VA_ARGS__)
#define NN_DETAIL_PSC_TRACE_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(psc, Trace, 3, ##__VA_ARGS__)

#define NN_DETAIL_PSC_INFO(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(psc, Info, 0, ##__VA_ARGS__)
#define NN_DETAIL_PSC_INFO_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(psc, Info, 1, ##__VA_ARGS__)
#define NN_DETAIL_PSC_INFO_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(psc, Info, 2, ##__VA_ARGS__)
#define NN_DETAIL_PSC_INFO_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(psc, Info, 3, ##__VA_ARGS__)

#define NN_DETAIL_PSC_WARN(...)                     NN_DETAIL_STRUCTURED_SDK_LOG(psc, Warn, 0, ##__VA_ARGS__)
#define NN_DETAIL_PSC_WARN_V1(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(psc, Warn, 1, ##__VA_ARGS__)
#define NN_DETAIL_PSC_WARN_V2(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(psc, Warn, 2, ##__VA_ARGS__)
#define NN_DETAIL_PSC_WARN_V3(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(psc, Warn, 3, ##__VA_ARGS__)

#define NN_DETAIL_PSC_ERROR(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(psc, Error, 0, ##__VA_ARGS__)
#define NN_DETAIL_PSC_ERROR_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(psc, Error, 1, ##__VA_ARGS__)
#define NN_DETAIL_PSC_ERROR_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(psc, Error, 2, ##__VA_ARGS__)
#define NN_DETAIL_PSC_ERROR_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(psc, Error, 3, ##__VA_ARGS__)

#define NN_DETAIL_PSC_FATAL(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(psc, Fatal, 0, ##__VA_ARGS__)
#define NN_DETAIL_PSC_FATAL_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(psc, Fatal, 1, ##__VA_ARGS__)
#define NN_DETAIL_PSC_FATAL_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(psc, Fatal, 2, ##__VA_ARGS__)
#define NN_DETAIL_PSC_FATAL_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(psc, Fatal, 3, ##__VA_ARGS__)

#define NN_DETAIL_PSC_VTRACE(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(psc, Trace, 0, format, args)
#define NN_DETAIL_PSC_VTRACE_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(psc, Trace, 1, format, args)
#define NN_DETAIL_PSC_VTRACE_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(psc, Trace, 2, format, args)
#define NN_DETAIL_PSC_VTRACE_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(psc, Trace, 3, format, args)

#define NN_DETAIL_PSC_VINFO(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(psc, Info, 0, format, args)
#define NN_DETAIL_PSC_VINFO_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(psc, Info, 1, format, args)
#define NN_DETAIL_PSC_VINFO_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(psc, Info, 2, format, args)
#define NN_DETAIL_PSC_VINFO_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(psc, Info, 3, format, args)

#define NN_DETAIL_PSC_VWARN(format, args)           NN_DETAIL_STRUCTURED_SDK_VLOG(psc, Warn, 0, format, args)
#define NN_DETAIL_PSC_VWARN_V1(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(psc, Warn, 1, format, args)
#define NN_DETAIL_PSC_VWARN_V2(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(psc, Warn, 2, format, args)
#define NN_DETAIL_PSC_VWARN_V3(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(psc, Warn, 3, format, args)

#define NN_DETAIL_PSC_VERROR(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(psc, Error, 0, format, args)
#define NN_DETAIL_PSC_VERROR_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(psc, Error, 1, format, args)
#define NN_DETAIL_PSC_VERROR_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(psc, Error, 2, format, args)
#define NN_DETAIL_PSC_VERROR_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(psc, Error, 3, format, args)

#define NN_DETAIL_PSC_VFATAL(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(psc, Fatal, 0, format, args)
#define NN_DETAIL_PSC_VFATAL_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(psc, Fatal, 1, format, args)
#define NN_DETAIL_PSC_VFATAL_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(psc, Fatal, 2, format, args)
#define NN_DETAIL_PSC_VFATAL_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(psc, Fatal, 3, format, args)

#define NN_DETAIL_PSC_PUT_TRACE(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(psc, Trace, 0, text, length)
#define NN_DETAIL_PSC_PUT_TRACE_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(psc, Trace, 1, text, length)
#define NN_DETAIL_PSC_PUT_TRACE_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(psc, Trace, 2, text, length)
#define NN_DETAIL_PSC_PUT_TRACE_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(psc, Trace, 3, text, length)

#define NN_DETAIL_PSC_PUT_INFO(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(psc, Info, 0, text, length)
#define NN_DETAIL_PSC_PUT_INFO_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(psc, Info, 1, text, length)
#define NN_DETAIL_PSC_PUT_INFO_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(psc, Info, 2, text, length)
#define NN_DETAIL_PSC_PUT_INFO_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(psc, Info, 3, text, length)

#define NN_DETAIL_PSC_PUT_WARN(text, length)        NN_DETAIL_STRUCTURED_SDK_PUT(psc, Warn, 0, text, length)
#define NN_DETAIL_PSC_PUT_WARN_V1(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(psc, Warn, 1, text, length)
#define NN_DETAIL_PSC_PUT_WARN_V2(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(psc, Warn, 2, text, length)
#define NN_DETAIL_PSC_PUT_WARN_V3(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(psc, Warn, 3, text, length)

#define NN_DETAIL_PSC_PUT_ERROR(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(psc, Error, 0, text, length)
#define NN_DETAIL_PSC_PUT_ERROR_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(psc, Error, 1, text, length)
#define NN_DETAIL_PSC_PUT_ERROR_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(psc, Error, 2, text, length)
#define NN_DETAIL_PSC_PUT_ERROR_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(psc, Error, 3, text, length)

#define NN_DETAIL_PSC_PUT_FATAL(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(psc, Fatal, 0, text, length)
#define NN_DETAIL_PSC_PUT_FATAL_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(psc, Fatal, 1, text, length)
#define NN_DETAIL_PSC_PUT_FATAL_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(psc, Fatal, 2, text, length)
#define NN_DETAIL_PSC_PUT_FATAL_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(psc, Fatal, 3, text, length)
