﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Abort.h>
#include <nn/nn_SdkAssert.h>
#include <nn/nn_SdkLog.h>
#include <nn/nn_StaticAssert.h>
#include <nn/nn_SystemThreadDefinition.h>
#include <nn/nn_ApplicationId.h>
#include <algorithm>
#include <atomic>
#include <cstdio>
#include <cstring>

#if defined (NN_BUILD_CONFIG_OS_WIN)
#include <nn/nn_Windows.h>
#endif

#include <nn/os.h>
#include <nn/os/os_SdkMutex.h>
#include <nn/fs.h>
#include <nn/account/account_Types.h>
#include <nn/account/account_Result.h>
#include <nn/time.h>
#include <nn/util/util_FormatString.h>
#include <nn/util/util_LockGuard.h>
#include <nn/util/util_ScopeExit.h>
#include <nn/util/util_Span.h>
#include <nn/util/util_StringUtil.h>
#include <nn/util/util_Uuid.h>
#include <nn/result/result_HandlingUtility.h>

#include <nn/prepo/prepo_Result.h>
#include <nn/prepo/prepo_ResultPrivate.h>

#include <nn/prepo/prepo_Types.h>
#include <nn/prepo/prepo_TypesDebug.h>

#include <nn/prepo/detail/prepo_Log.h>
#include <nn/prepo/detail/prepo_TypesDetail.h>

#include <nn/prepo/detail/msgpack/prepo_MessagePack.h>

#include <nn/prepo/detail/service/prepo_TypesService.h>

#include <nn/prepo/detail/service/core/prepo_FileSystem.h>

#include <nn/prepo/detail/service/util/prepo_ReportError.h>

/*!
    @brief      システム情報を管理するストレージのマウント名です。
*/
#define NN_DETAIL_PREPO_SYSTEM_MOUNT_NAME "prepo-sys"

/*!
    @brief      レポートデータを管理するストレージのマウント名です。
*/
#define NN_DETAIL_PREPO_DATA_MOUNT_NAME "prepo"

/*!
    @brief      重大度 Fatal のログ文字列を修飾します。

    @details
                文字列に プレフィックス [prepo] を付けて、色をマゼンタにします。
*/
#define NN_DETAIL_PREPO_STRING_FATAL(str) "\033[35m[prepo] " str "\033[m"

/*!
    @brief      重大度 Error のログ文字列を修飾します。

    @details
                文字列に プレフィックス [prepo] を付けて、赤にします。
*/
#define NN_DETAIL_PREPO_STRING_ERROR(str) "\033[31m[prepo] " str "\033[m"

/*!
    @brief      重大度 Warn のログ文字列を修飾します。

    @details
                文字列に プレフィックス [prepo] を付けて、色を黄にします。
*/
#define NN_DETAIL_PREPO_STRING_WARN(str) "\033[33m[prepo] " str "\033[m"

/*!
    @brief      exp の実行時間を測定して、ログに出力します。

    @attention
                exp が return すると、実行時間がログに出力されないため、注意してください。
*/
#if defined(NN_SDK_BUILD_DEBUG) || defined(NN_SDK_BUILD_DEVELOP)
    #define NN_DETAIL_PREPO_MEASURE_TIME(exp) \
        do                                                                          \
        {                                                                           \
            auto startTick = nn::os::GetSystemTick();                               \
            exp;                                                                    \
            auto endTick = nn::os::GetSystemTick();                                 \
            NN_DETAIL_PREPO_INFO("\033[36m[prepo] time=%8lld (usec) @%s\033[m\n",   \
                (endTick - startTick).ToTimeSpan().GetMicroSeconds(),               \
                (#exp));                                           \
        }                                                                           \
        while (NN_STATIC_CONDITION(false))
#elif defined(NN_SDK_BUILD_RELEASE)
    #define NN_DETAIL_PREPO_MEASURE_TIME(exp) \
        do                                                                          \
        {                                                                           \
            exp;                                                                    \
        }                                                                           \
        while (NN_STATIC_CONDITION(false))
#else
    #error "ビルドタイプマクロが定義されていません。"
#endif

/*!
    @brief   論理値を返す式のエラーハンドリングを行うマクロです。

    @param[in]   Expression  論理値を返す式。
*/
#define NN_DETAIL_PREPO_RETURN_IF_FALSE(Expression) \
    do                                  \
    {                                   \
        bool _result = (Expression);    \
                                        \
        if (!_result)                   \
        {                               \
            return false;               \
        }                               \
    }                                   \
    while (NN_STATIC_CONDITION(false))
