﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/prepo/detail/service/core/prepo_ReportFileManager.h>
#include <nn/prepo/detail/service/core/prepo_UploadExecuter.h>

namespace nn { namespace prepo { namespace detail { namespace service { namespace core {

/*!
    @brief      レポートの分類ごとに存在するオブジェクトを管理するクラスです。
*/
class CategoryObject
{
private:
    NN_DISALLOW_COPY(CategoryObject);
    NN_DISALLOW_MOVE(CategoryObject);

public:
    /*!
        @brief      コンストラクタです。

        @param[in]  mountName                       レポートデータを管理するストレージのマウント名。
        @param[in]  isUserAgreementCheckRequired    「ユーザー情報を送信」に同意が必要なレポートデータを管理するか。
    */
    CategoryObject(const char* mountName, bool isUserAgreementCheckRequired) NN_NOEXCEPT;

public:
    /*!
        @brief      分類に対応する ReportFileManager を取得します。

        @param[in]  category    レポートの分類。

        @return     ReportFileManager。
    */
    static ReportFileManager& GetReportFileManager(ReportCategory category) NN_NOEXCEPT;

    /*!
        @brief      分類に対応する UploadExecuter を取得します。

        @param[in]  category    レポートの分類。

        @return     UploadExecuter。
    */
    static UploadExecuter& GetUploadExecuter(ReportCategory category) NN_NOEXCEPT;

    /*!
        @brief      アップロード処理を実行します。

        @param[in]  isImmediate 即時実行するかどうか。
    */
    static nn::Result ExecuteUpload(bool isImmediate) NN_NOEXCEPT;

private:
    static CategoryObject& GetObject(ReportCategory category) NN_NOEXCEPT;

private:
    ReportFileManager m_ReportFileManager;
    UploadExecuter m_UploadExecuter;

private:
    static nn::Bit8 g_ReportBuffer[ReportFileSizeMax];
};

}}}}}
