﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief      prepo モジュール用の、ログを出力する API の宣言です。
*/

#include <nn/nn_Common.h>
#include <nn/diag/detail/diag_DetailStructuredSdkLog.h>

#define NN_DETAIL_PREPO_TRACE(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(prepo, Trace, 0, ##__VA_ARGS__)
#define NN_DETAIL_PREPO_TRACE_V1(...)               NN_DETAIL_STRUCTURED_SDK_LOG(prepo, Trace, 1, ##__VA_ARGS__)
#define NN_DETAIL_PREPO_TRACE_V2(...)               NN_DETAIL_STRUCTURED_SDK_LOG(prepo, Trace, 2, ##__VA_ARGS__)
#define NN_DETAIL_PREPO_TRACE_V3(...)               NN_DETAIL_STRUCTURED_SDK_LOG(prepo, Trace, 3, ##__VA_ARGS__)

#define NN_DETAIL_PREPO_INFO(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(prepo, Info, 0, ##__VA_ARGS__)
#define NN_DETAIL_PREPO_INFO_V1(...)                NN_DETAIL_STRUCTURED_SDK_LOG(prepo, Info, 1, ##__VA_ARGS__)
#define NN_DETAIL_PREPO_INFO_V2(...)                NN_DETAIL_STRUCTURED_SDK_LOG(prepo, Info, 2, ##__VA_ARGS__)
#define NN_DETAIL_PREPO_INFO_V3(...)                NN_DETAIL_STRUCTURED_SDK_LOG(prepo, Info, 3, ##__VA_ARGS__)

#define NN_DETAIL_PREPO_WARN(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(prepo, Warn, 0, ##__VA_ARGS__)
#define NN_DETAIL_PREPO_WARN_V1(...)                NN_DETAIL_STRUCTURED_SDK_LOG(prepo, Warn, 1, ##__VA_ARGS__)
#define NN_DETAIL_PREPO_WARN_V2(...)                NN_DETAIL_STRUCTURED_SDK_LOG(prepo, Warn, 2, ##__VA_ARGS__)
#define NN_DETAIL_PREPO_WARN_V3(...)                NN_DETAIL_STRUCTURED_SDK_LOG(prepo, Warn, 3, ##__VA_ARGS__)

#define NN_DETAIL_PREPO_ERROR(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(prepo, Error, 0, ##__VA_ARGS__)
#define NN_DETAIL_PREPO_ERROR_V1(...)               NN_DETAIL_STRUCTURED_SDK_LOG(prepo, Error, 1, ##__VA_ARGS__)
#define NN_DETAIL_PREPO_ERROR_V2(...)               NN_DETAIL_STRUCTURED_SDK_LOG(prepo, Error, 2, ##__VA_ARGS__)
#define NN_DETAIL_PREPO_ERROR_V3(...)               NN_DETAIL_STRUCTURED_SDK_LOG(prepo, Error, 3, ##__VA_ARGS__)

#define NN_DETAIL_PREPO_FATAL(...)                  NN_DETAIL_STRUCTURED_SDK_LOG(prepo, Fatal, 0, ##__VA_ARGS__)
#define NN_DETAIL_PREPO_FATAL_V1(...)               NN_DETAIL_STRUCTURED_SDK_LOG(prepo, Fatal, 1, ##__VA_ARGS__)
#define NN_DETAIL_PREPO_FATAL_V2(...)               NN_DETAIL_STRUCTURED_SDK_LOG(prepo, Fatal, 2, ##__VA_ARGS__)
#define NN_DETAIL_PREPO_FATAL_V3(...)               NN_DETAIL_STRUCTURED_SDK_LOG(prepo, Fatal, 3, ##__VA_ARGS__)

#define NN_DETAIL_PREPO_VTRACE(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(prepo, Trace, 0, format, args)
#define NN_DETAIL_PREPO_VTRACE_V1(format, args)     NN_DETAIL_STRUCTURED_SDK_VLOG(prepo, Trace, 1, format, args)
#define NN_DETAIL_PREPO_VTRACE_V2(format, args)     NN_DETAIL_STRUCTURED_SDK_VLOG(prepo, Trace, 2, format, args)
#define NN_DETAIL_PREPO_VTRACE_V3(format, args)     NN_DETAIL_STRUCTURED_SDK_VLOG(prepo, Trace, 3, format, args)

#define NN_DETAIL_PREPO_VINFO(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(prepo, Info, 0, format, args)
#define NN_DETAIL_PREPO_VINFO_V1(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(prepo, Info, 1, format, args)
#define NN_DETAIL_PREPO_VINFO_V2(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(prepo, Info, 2, format, args)
#define NN_DETAIL_PREPO_VINFO_V3(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(prepo, Info, 3, format, args)

#define NN_DETAIL_PREPO_VWARN(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(prepo, Warn, 0, format, args)
#define NN_DETAIL_PREPO_VWARN_V1(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(prepo, Warn, 1, format, args)
#define NN_DETAIL_PREPO_VWARN_V2(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(prepo, Warn, 2, format, args)
#define NN_DETAIL_PREPO_VWARN_V3(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(prepo, Warn, 3, format, args)

#define NN_DETAIL_PREPO_VERROR(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(prepo, Error, 0, format, args)
#define NN_DETAIL_PREPO_VERROR_V1(format, args)     NN_DETAIL_STRUCTURED_SDK_VLOG(prepo, Error, 1, format, args)
#define NN_DETAIL_PREPO_VERROR_V2(format, args)     NN_DETAIL_STRUCTURED_SDK_VLOG(prepo, Error, 2, format, args)
#define NN_DETAIL_PREPO_VERROR_V3(format, args)     NN_DETAIL_STRUCTURED_SDK_VLOG(prepo, Error, 3, format, args)

#define NN_DETAIL_PREPO_VFATAL(format, args)        NN_DETAIL_STRUCTURED_SDK_VLOG(prepo, Fatal, 0, format, args)
#define NN_DETAIL_PREPO_VFATAL_V1(format, args)     NN_DETAIL_STRUCTURED_SDK_VLOG(prepo, Fatal, 1, format, args)
#define NN_DETAIL_PREPO_VFATAL_V2(format, args)     NN_DETAIL_STRUCTURED_SDK_VLOG(prepo, Fatal, 2, format, args)
#define NN_DETAIL_PREPO_VFATAL_V3(format, args)     NN_DETAIL_STRUCTURED_SDK_VLOG(prepo, Fatal, 3, format, args)

#define NN_DETAIL_PREPO_PUT_TRACE(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(prepo, Trace, 0, text, length)
#define NN_DETAIL_PREPO_PUT_TRACE_V1(text, length)  NN_DETAIL_STRUCTURED_SDK_PUT(prepo, Trace, 1, text, length)
#define NN_DETAIL_PREPO_PUT_TRACE_V2(text, length)  NN_DETAIL_STRUCTURED_SDK_PUT(prepo, Trace, 2, text, length)
#define NN_DETAIL_PREPO_PUT_TRACE_V3(text, length)  NN_DETAIL_STRUCTURED_SDK_PUT(prepo, Trace, 3, text, length)

#define NN_DETAIL_PREPO_PUT_INFO(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(prepo, Info, 0, text, length)
#define NN_DETAIL_PREPO_PUT_INFO_V1(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(prepo, Info, 1, text, length)
#define NN_DETAIL_PREPO_PUT_INFO_V2(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(prepo, Info, 2, text, length)
#define NN_DETAIL_PREPO_PUT_INFO_V3(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(prepo, Info, 3, text, length)

#define NN_DETAIL_PREPO_PUT_WARN(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(prepo, Warn, 0, text, length)
#define NN_DETAIL_PREPO_PUT_WARN_V1(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(prepo, Warn, 1, text, length)
#define NN_DETAIL_PREPO_PUT_WARN_V2(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(prepo, Warn, 2, text, length)
#define NN_DETAIL_PREPO_PUT_WARN_V3(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(prepo, Warn, 3, text, length)

#define NN_DETAIL_PREPO_PUT_ERROR(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(prepo, Error, 0, text, length)
#define NN_DETAIL_PREPO_PUT_ERROR_V1(text, length)  NN_DETAIL_STRUCTURED_SDK_PUT(prepo, Error, 1, text, length)
#define NN_DETAIL_PREPO_PUT_ERROR_V2(text, length)  NN_DETAIL_STRUCTURED_SDK_PUT(prepo, Error, 2, text, length)
#define NN_DETAIL_PREPO_PUT_ERROR_V3(text, length)  NN_DETAIL_STRUCTURED_SDK_PUT(prepo, Error, 3, text, length)

#define NN_DETAIL_PREPO_PUT_FATAL(text, length)     NN_DETAIL_STRUCTURED_SDK_PUT(prepo, Fatal, 0, text, length)
#define NN_DETAIL_PREPO_PUT_FATAL_V1(text, length)  NN_DETAIL_STRUCTURED_SDK_PUT(prepo, Fatal, 1, text, length)
#define NN_DETAIL_PREPO_PUT_FATAL_V2(text, length)  NN_DETAIL_STRUCTURED_SDK_PUT(prepo, Fatal, 2, text, length)
#define NN_DETAIL_PREPO_PUT_FATAL_V3(text, length)  NN_DETAIL_STRUCTURED_SDK_PUT(prepo, Fatal, 3, text, length)
