﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/time/time_PosixTime.h>
#include <nn/pdm/pdm_PrivateTypes.h>
#include <nn/pdm/pdm_SystemTypes.h>

namespace nn { namespace pdm { namespace detail {

void InitializeTime() NN_NOEXCEPT;

nn::time::PosixTime GetUserClockTimeForPlayEvent() NN_NOEXCEPT;
nn::time::PosixTime GetNetworkClockTimeForPlayEvent() NN_NOEXCEPT;
int64_t GetSteadyClockTimeForPlayEvent() NN_NOEXCEPT;

uint32_t GetElapsedMinutesSinceInputPosixTimeMin(const time::PosixTime& time) NN_NOEXCEPT;

uint32_t GetLastSteadyClockResetEventIndex() NN_NOEXCEPT;

/**
* @brief    デバッグ用に単調増加時計のリセット時点の情報を設定します。永続化はしません。
*/
void SetLastSteadyClockResetPointForDebug(uint32_t index, nn::TimeSpan elapsedTimeSinceReset) NN_NOEXCEPT;

}}}
