﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/account/account_Types.h>
#include <nn/ncm/ncm_ProgramId.h>
#include <nn/ncm/ncm_StorageId.h>
#include <nn/nn_Result.h>
#include <nn/ns/ns_ApplicationManagerApi.h>
#include <nn/pdm/pdm_PrivateTypes.h>
#include <nn/pdm/pdm_SystemTypes.h>
#include <nn/sf/sf_Types.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace pdm { namespace detail { // NOLINT(whitespace/braces)

class INotifyService;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(INotifyService, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(INotifyService)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(NotifyAppletEvent, (::nn::pdm::AppletEventType eventType, ::nn::ncm::ProgramId programId, ::std::uint32_t version, ::std::uint8_t appletId, ::nn::ncm::StorageId storageId, ::nn::ns::PlayLogPolicy logPolicy))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(NotifyOperationModeChangeEvent, (::nn::pdm::OperationMode eventType))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(NotifyPowerStateChangeEvent, (::nn::pdm::PowerStateChangeEventType eventType))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(NotifyClearAllEvent)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(NotifyEventForDebug, (const ::nn::sf::InArray<::nn::pdm::PlayEvent>& playEventArray))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SuspendUserAccountEventService, (const ::nn::account::Uid& user))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ResumeUserAccountEventService, (const ::nn::account::Uid& user))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(NotifyLibraryAppletEvent, (::nn::pdm::AppletEventType eventType, ::nn::ncm::ProgramId mainProgramId, ::std::uint8_t libraryAppletMode, ::std::uint8_t appletId, ::nn::ncm::StorageId storageId, ::nn::ns::PlayLogPolicy logPolicy))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(INotifyService)

        ::nn::Result NotifyAppletEvent(::nn::pdm::AppletEventType eventType, ::nn::ncm::ProgramId programId, ::std::uint32_t version, ::std::uint8_t appletId, ::nn::ncm::StorageId storageId, ::nn::ns::PlayLogPolicy logPolicy) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(NotifyAppletEvent, (eventType, programId, version, appletId, storageId, logPolicy));
        }

        ::nn::Result NotifyOperationModeChangeEvent(::nn::pdm::OperationMode eventType) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(NotifyOperationModeChangeEvent, (eventType));
        }

        ::nn::Result NotifyPowerStateChangeEvent(::nn::pdm::PowerStateChangeEventType eventType) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(NotifyPowerStateChangeEvent, (eventType));
        }

        ::nn::Result NotifyClearAllEvent() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(NotifyClearAllEvent);
        }

        ::nn::Result NotifyEventForDebug(const ::nn::sf::InArray<::nn::pdm::PlayEvent>& playEventArray) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(NotifyEventForDebug, (playEventArray));
        }

        ::nn::Result SuspendUserAccountEventService(const ::nn::account::Uid& user) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SuspendUserAccountEventService, (user));
        }

        ::nn::Result ResumeUserAccountEventService(const ::nn::account::Uid& user) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ResumeUserAccountEventService, (user));
        }

        ::nn::Result NotifyLibraryAppletEvent(::nn::pdm::AppletEventType eventType, ::nn::ncm::ProgramId mainProgramId, ::std::uint8_t libraryAppletMode, ::std::uint8_t appletId, ::nn::ncm::StorageId storageId, ::nn::ns::PlayLogPolicy logPolicy) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(NotifyLibraryAppletEvent, (eventType, mainProgramId, libraryAppletMode, appletId, storageId, logPolicy));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class INotifyService
    {
    public:
        nn::Result NotifyAppletEvent(nn::pdm::AppletEventType eventType, nn::ncm::ProgramId programId, std::uint32_t version, std::uint8_t appletId, nn::ncm::StorageId storageId, nn::ns::PlayLogPolicy logPolicy) NN_NOEXCEPT;
        nn::Result NotifyOperationModeChangeEvent(nn::pdm::OperationMode eventType) NN_NOEXCEPT;
        nn::Result NotifyPowerStateChangeEvent(nn::pdm::PowerStateChangeEventType eventType) NN_NOEXCEPT;
        nn::Result NotifyClearAllEvent() NN_NOEXCEPT;
        nn::Result NotifyEventForDebug(const nn::sf::InArray<nn::pdm::PlayEvent>& playEventArray) NN_NOEXCEPT;
        nn::Result SuspendUserAccountEventService(const nn::account::Uid& user) NN_NOEXCEPT;
        nn::Result ResumeUserAccountEventService(const nn::account::Uid& user) NN_NOEXCEPT;
        nn::Result NotifyLibraryAppletEvent(nn::pdm::AppletEventType eventType, nn::ncm::ProgramId mainProgramId, std::uint8_t libraryAppletMode, std::uint8_t appletId, nn::ncm::StorageId storageId, nn::ns::PlayLogPolicy logPolicy) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result NotifyAppletEvent(nn::pdm::AppletEventType eventType, nn::ncm::ProgramId programId, std::uint32_t version, std::uint8_t appletId, nn::ncm::StorageId storageId, nn::ns::PlayLogPolicy logPolicy) NN_NOEXCEPT;
    nn::Result NotifyOperationModeChangeEvent(nn::pdm::OperationMode eventType) NN_NOEXCEPT;
    nn::Result NotifyPowerStateChangeEvent(nn::pdm::PowerStateChangeEventType eventType) NN_NOEXCEPT;
    nn::Result NotifyClearAllEvent() NN_NOEXCEPT;
    nn::Result NotifyEventForDebug(const nn::sf::InArray<nn::pdm::PlayEvent>& playEventArray) NN_NOEXCEPT;
    nn::Result SuspendUserAccountEventService(const nn::account::Uid& user) NN_NOEXCEPT;
    nn::Result ResumeUserAccountEventService(const nn::account::Uid& user) NN_NOEXCEPT;
    nn::Result NotifyLibraryAppletEvent(nn::pdm::AppletEventType eventType, nn::ncm::ProgramId mainProgramId, std::uint8_t libraryAppletMode, std::uint8_t appletId, nn::ncm::StorageId storageId, nn::ns::PlayLogPolicy logPolicy) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::pdm::detail::INotifyService))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(NotifyAppletEvent, (::nn::pdm::AppletEventType eventType, ::nn::ncm::ProgramId programId, ::std::uint32_t version, ::std::uint8_t appletId, ::nn::ncm::StorageId storageId, ::nn::ns::PlayLogPolicy logPolicy))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(NotifyAppletEvent, (eventType, programId, version, appletId, storageId, logPolicy));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(NotifyOperationModeChangeEvent, (::nn::pdm::OperationMode eventType))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(NotifyOperationModeChangeEvent, (eventType));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(NotifyPowerStateChangeEvent, (::nn::pdm::PowerStateChangeEventType eventType))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(NotifyPowerStateChangeEvent, (eventType));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(NotifyClearAllEvent)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(NotifyClearAllEvent);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(NotifyEventForDebug, (const ::nn::sf::InArray<::nn::pdm::PlayEvent>& playEventArray))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(NotifyEventForDebug, (playEventArray));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SuspendUserAccountEventService, (const ::nn::account::Uid& user))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SuspendUserAccountEventService, (user));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ResumeUserAccountEventService, (const ::nn::account::Uid& user))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ResumeUserAccountEventService, (user));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(NotifyLibraryAppletEvent, (::nn::pdm::AppletEventType eventType, ::nn::ncm::ProgramId mainProgramId, ::std::uint8_t libraryAppletMode, ::std::uint8_t appletId, ::nn::ncm::StorageId storageId, ::nn::ns::PlayLogPolicy logPolicy))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(NotifyLibraryAppletEvent, (eventType, mainProgramId, libraryAppletMode, appletId, storageId, logPolicy));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::pdm::detail::INotifyService>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::pdm::detail::INotifyService))

    // nn::Result NotifyAppletEvent(nn::pdm::AppletEventType eventType, nn::ncm::ProgramId programId, std::uint32_t version, std::uint8_t appletId, nn::ncm::StorageId storageId, nn::ns::PlayLogPolicy logPolicy) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(NotifyAppletEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(eventType, (::nn::pdm::AppletEventType), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(appletId, (::std::uint8_t), 1)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(storageId, (::nn::ncm::StorageId), 2)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(logPolicy, (::nn::ns::PlayLogPolicy), 3)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(version, (::std::uint32_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(programId, (::nn::ncm::ProgramId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(6, (eventType, appletId, storageId, logPolicy, version, programId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(eventType), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(programId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(version), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(appletId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(storageId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(logPolicy)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(NotifyAppletEvent)

    // nn::Result NotifyOperationModeChangeEvent(nn::pdm::OperationMode eventType) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(NotifyOperationModeChangeEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(eventType, (::nn::pdm::OperationMode), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (eventType))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(eventType)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(NotifyOperationModeChangeEvent)

    // nn::Result NotifyPowerStateChangeEvent(nn::pdm::PowerStateChangeEventType eventType) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(NotifyPowerStateChangeEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(eventType, (::nn::pdm::PowerStateChangeEventType), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (eventType))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(eventType)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(NotifyPowerStateChangeEvent)

    // nn::Result NotifyClearAllEvent() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(NotifyClearAllEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(NotifyClearAllEvent)

    // nn::Result NotifyEventForDebug(const nn::sf::InArray<nn::pdm::PlayEvent>& playEventArray) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(NotifyEventForDebug)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(5)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(playEventArray, 0, (const ::nn::sf::InArray<::nn::pdm::PlayEvent>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (playEventArray))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(playEventArray)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(NotifyEventForDebug)

    // nn::Result SuspendUserAccountEventService(const nn::account::Uid& user) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SuspendUserAccountEventService)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(6)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(user, (::nn::account::Uid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (user))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(user)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SuspendUserAccountEventService)

    // nn::Result ResumeUserAccountEventService(const nn::account::Uid& user) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ResumeUserAccountEventService)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(7)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(user, (::nn::account::Uid), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (user))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(user)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ResumeUserAccountEventService)

    // nn::Result NotifyLibraryAppletEvent(nn::pdm::AppletEventType eventType, nn::ncm::ProgramId mainProgramId, std::uint8_t libraryAppletMode, std::uint8_t appletId, nn::ncm::StorageId storageId, nn::ns::PlayLogPolicy logPolicy) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(NotifyLibraryAppletEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(eventType, (::nn::pdm::AppletEventType), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(libraryAppletMode, (::std::uint8_t), 1)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(appletId, (::std::uint8_t), 2)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(storageId, (::nn::ncm::StorageId), 3)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(logPolicy, (::nn::ns::PlayLogPolicy), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(mainProgramId, (::nn::ncm::ProgramId), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(6, (eventType, libraryAppletMode, appletId, storageId, logPolicy, mainProgramId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(eventType), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(mainProgramId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(libraryAppletMode), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(appletId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(storageId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(logPolicy)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(NotifyLibraryAppletEvent)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::pdm::AppletEventType), 1, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ncm::ProgramId), 8, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ncm::StorageId), 1, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::ns::PlayLogPolicy), 1, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::pdm::OperationMode), 1, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::pdm::PowerStateChangeEventType), 1, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::pdm::PlayEvent), 56, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::account::Uid), 16, 8)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::pdm::detail::INotifyService, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::pdm::detail::INotifyService))

    // nn::Result NotifyAppletEvent(nn::pdm::AppletEventType eventType, nn::ncm::ProgramId programId, std::uint32_t version, std::uint8_t appletId, nn::ncm::StorageId storageId, nn::ns::PlayLogPolicy logPolicy) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(NotifyAppletEvent, (::nn::pdm::AppletEventType eventType, ::nn::ncm::ProgramId programId, ::std::uint32_t version, ::std::uint8_t appletId, ::nn::ncm::StorageId storageId, ::nn::ns::PlayLogPolicy logPolicy))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(NotifyAppletEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(eventType)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(programId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(version)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(appletId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(storageId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(logPolicy)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(NotifyAppletEvent)
    }

    // nn::Result NotifyOperationModeChangeEvent(nn::pdm::OperationMode eventType) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(NotifyOperationModeChangeEvent, (::nn::pdm::OperationMode eventType))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(NotifyOperationModeChangeEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(eventType)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(NotifyOperationModeChangeEvent)
    }

    // nn::Result NotifyPowerStateChangeEvent(nn::pdm::PowerStateChangeEventType eventType) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(NotifyPowerStateChangeEvent, (::nn::pdm::PowerStateChangeEventType eventType))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(NotifyPowerStateChangeEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(eventType)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(NotifyPowerStateChangeEvent)
    }

    // nn::Result NotifyClearAllEvent() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(NotifyClearAllEvent)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(NotifyClearAllEvent)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(NotifyClearAllEvent)
    }

    // nn::Result NotifyEventForDebug(const nn::sf::InArray<nn::pdm::PlayEvent>& playEventArray) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(NotifyEventForDebug, (const ::nn::sf::InArray<::nn::pdm::PlayEvent>& playEventArray))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(NotifyEventForDebug)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(playEventArray)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(NotifyEventForDebug)
    }

    // nn::Result SuspendUserAccountEventService(const nn::account::Uid& user) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SuspendUserAccountEventService, (const ::nn::account::Uid& user))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SuspendUserAccountEventService)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(user)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SuspendUserAccountEventService)
    }

    // nn::Result ResumeUserAccountEventService(const nn::account::Uid& user) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ResumeUserAccountEventService, (const ::nn::account::Uid& user))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ResumeUserAccountEventService)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(user)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ResumeUserAccountEventService)
    }

    // nn::Result NotifyLibraryAppletEvent(nn::pdm::AppletEventType eventType, nn::ncm::ProgramId mainProgramId, std::uint8_t libraryAppletMode, std::uint8_t appletId, nn::ncm::StorageId storageId, nn::ns::PlayLogPolicy logPolicy) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(NotifyLibraryAppletEvent, (::nn::pdm::AppletEventType eventType, ::nn::ncm::ProgramId mainProgramId, ::std::uint8_t libraryAppletMode, ::std::uint8_t appletId, ::nn::ncm::StorageId storageId, ::nn::ns::PlayLogPolicy logPolicy))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(NotifyLibraryAppletEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(eventType)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(mainProgramId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(libraryAppletMode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(appletId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(storageId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(logPolicy)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(NotifyLibraryAppletEvent)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::pdm::detail::INotifyService>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::pdm::detail::INotifyService))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(NotifyAppletEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(NotifyAppletEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(eventType),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(programId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(version),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(appletId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(storageId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(logPolicy)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(NotifyOperationModeChangeEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(NotifyOperationModeChangeEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(eventType)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(NotifyPowerStateChangeEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(NotifyPowerStateChangeEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(eventType)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(NotifyClearAllEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(NotifyClearAllEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(NotifyEventForDebug)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(playEventArray)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(NotifyEventForDebug)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(playEventArray)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SuspendUserAccountEventService)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SuspendUserAccountEventService)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(user)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ResumeUserAccountEventService)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ResumeUserAccountEventService)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(user)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(NotifyLibraryAppletEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(NotifyLibraryAppletEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(eventType),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(mainProgramId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(libraryAppletMode),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(appletId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(storageId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(logPolicy)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(NotifyAppletEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(NotifyOperationModeChangeEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(NotifyPowerStateChangeEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(NotifyClearAllEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(NotifyEventForDebug)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SuspendUserAccountEventService)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ResumeUserAccountEventService)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(NotifyLibraryAppletEvent)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::pdm::detail::INotifyService))
