﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/fs/fs_SystemSaveData.h>
#include <nn/nn_Common.h>
#include <nn/pdm/pdm_PrivateTypes.h>

namespace nn { namespace pdm { namespace detail {

/**
* @brief    PDM がシステムセーブデータのマウントに使用する名前です。
*/
const char* const MountName = "pdm";

/**
* @brief    PDM が使用するシステムセーブデータのIDです。
*/
const nn::fs::SystemSaveDataId SystemSaveDataId{ 0x80000000000000f0llu };

/**
* @brief    PDM が使用するシステムセーブデータのサイズです。
*/
const int SystemSaveDataSize = 16 * 1024 * 1024;

/**
* @brief    PDM が使用するシステムセーブデータのジャーナルサイズです。
*/
const int SystemSaveDataJournalSize = 128 * 1024;

/**
* @brief    ファイルに保存できるイベントの最大数です。
* @details  管理ブロック（32KiB）、イベント以外のファイル用（1つ * 16KiB）、その他の猶予（128KiB）の領域以外を割り当てます。
*/
const uint32_t PlayEventCountMax = (SystemSaveDataSize - (32 * 1024) - (1 * 16 * 1024) - (128 * 1024)) / sizeof(PlayEvent);

// 以下デバッグ用
// PDM_USE_HOST_FS を定義すると PlayEvent の保存先に HostDirPath を使うようになります。
// #define PDM_USE_HOST_FS
// const char* const HostDirPath = "C:\\Temp";

/**
 * @brief   デバイスDBからアカウントDBへの移行の完了を示す、永続化ファイルです。
 *          @ref detail::MountName の変更に伴ってマウントスキームを変更してください。
 */
const char* const MigrationCompleteFilePath = "pdm:/migration.ok";

}}}
