﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief クロックを操作する権利の調停機能の API 宣言。
 */

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

#include "pcv_Types.h"

namespace nn { namespace pcv {

//-----------------------------------------------------------------------------
//! @name PCV ライブラリの調停機能の API
//! @{

/**
 * @brief       指定したモジュールのクロックを操作する権利を手放します。
 *
 * @param[in]   moduleId 制御対象モジュール
 *
 * @return      処理の結果を返します。
 *
 * @retval      ResultSuccess 成功しました。
 *
 * @pre         @ref nn::pcv::InitializeForArbitration 関数を実行してライブラリを初期化している必要があります。
 *
 * @post        @a moduleId のクロックを操作する権利を PCV が取得します。
 *
 * @details     指定したモジュールのクロックを操作する権利を手放します。
 */

Result ReleaseControl(Module moduleId) NN_NOEXCEPT;

//! @}
//-----------------------------------------------------------------------------

}} // namespace nn::pcv
