﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

namespace nn { namespace pctl {

/**
 * @brief ペアレンタルコントロール設定の制限レベルを示す値です。
 *
 * @details
 * 各値の意味・説明は地域によって異なる場合がありますが、レベルの分類(段階)は本 enum 値に従います。
 */
enum SafetyLevel
{
    SafetyLevel_None = 0,              //!< 設定なし
    SafetyLevel_Custom,                //!< カスタム設定
    SafetyLevel_Children,              //!< 小学生・幼児
    SafetyLevel_YoungTeens,            //!< 中学生
    SafetyLevel_OlderTeens,            //!< 高校生
    SafetyLevel_Max                    //!< (内部で使用される値のため使用しないでください。)
};

/**
 * @brief ペアレンタルコントロールの制限設定値を表します。
 */
struct RestrictionSettings
{
    uint8_t ratingAge;                 //!< レーティング制限に利用する年齢(0 の場合はレーティング制限なし)
    bool snsPostRestriction;           //!< SNS投稿機能利用の制限
    bool freeCommunicationRestriction; //!< 他の人との自由なコミュニケーション機能の利用に関する既定の制限値
};

}}
