﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_ApplicationId.h>
#include <nn/nn_Common.h>
#include <nn/nn_Version.h>
#include <type_traits>

namespace nn { namespace pctl { namespace detail { namespace service {

// バージョン値のマクロ(定数)を文字列に変換するための関数マクロ
#define NN_DETAIL_PCTL_CONFIG_VERSION_NUMBER_TO_STRING_(num) # num
#define NN_DETAIL_PCTL_CONFIG_VERSION_NUMBER_TO_STRING(num)  NN_DETAIL_PCTL_CONFIG_VERSION_NUMBER_TO_STRING_(num)
#define NN_DETAIL_PCTL_CONFIG_VERSION_TO_STRING(major, minor, micro, relstep) \
    NN_DETAIL_PCTL_CONFIG_VERSION_NUMBER_TO_STRING(major) "." \
    NN_DETAIL_PCTL_CONFIG_VERSION_NUMBER_TO_STRING(minor) "." \
    NN_DETAIL_PCTL_CONFIG_VERSION_NUMBER_TO_STRING(micro) "." \
    NN_DETAIL_PCTL_CONFIG_VERSION_NUMBER_TO_STRING(relstep)

// SDKバージョンの文字列表記("x.x.x.x")
#define NN_DETAIL_PCTL_CONFIG_SDK_VERSION_STRING \
    NN_DETAIL_PCTL_CONFIG_VERSION_TO_STRING(NN_SDK_VERSION_MAJOR, NN_SDK_VERSION_MINOR, NN_SDK_VERSION_MICRO, NN_SDK_VERSION_RELSTEP)
#if defined(NN_BUILD_CONFIG_SPEC_NX)
// NX Addonバージョンの文字列表記("x.x.x.x")
#define NN_DETAIL_PCTL_CONFIG_NX_ADDON_VERSION_STRING \
    NN_DETAIL_PCTL_CONFIG_VERSION_TO_STRING(NN_NX_ADDON_VERSION_MAJOR, NN_NX_ADDON_VERSION_MINOR, NN_NX_ADDON_VERSION_MICRO, NN_NX_ADDON_VERSION_RELSTEP)
#endif

#define NN_DETAIL_PCTL_AGENT_SIGNATURE    "HAC-pctl"
#define NN_DETAIL_PCTL_VERSION_STRING     "1.0"

// pctlプロセスが使用するUser-Agent
static const char UserAgentHeaderForHttpRequest[] = "User-Agent: " NN_DETAIL_PCTL_AGENT_SIGNATURE "/" NN_DETAIL_PCTL_VERSION_STRING
    " (SDK " NN_DETAIL_PCTL_CONFIG_SDK_VERSION_STRING
#if defined(NN_DETAIL_PCTL_CONFIG_NX_ADDON_VERSION_STRING)
    "; Add-on " NN_DETAIL_PCTL_CONFIG_NX_ADDON_VERSION_STRING
#endif
    ")";
// pctlプロセスが使用する追加のバージョンヘッダー情報
static const char AdditionalVersionHeaderForHttpRequest[] = "X-Nintendo-SDK-Version: " NN_DETAIL_PCTL_CONFIG_SDK_VERSION_STRING;

// pctlプロセスのProgramId
static const nn::ApplicationId ApplicationIdPctl = { 0x010000000000002E };

// Bgtcのタスク(間欠起動での処理)を行う時間間隔(秒単位)
static const int IntermittentTaskIntervalSeconds = 6 * 60 * 60; // 6時間

// Mii画像(pngを想定)の最大データサイズ(バイト単位)
// ※ 無圧縮rawで考えると 128 pixel * 128 pixel * (24bit+1bit(alpha)) = 51200bytes
//    +（ヘッダー + チャンク）データで1KiBくらい余裕があれば大丈夫である想定なので
//    それを超えるだけのサイズを設定
static const size_t MaxMiiImageDataSize = 96 * 1024; // 96 KiB

// pctl向けのClientId
static const uint64_t PctlClientId = 0xdc656ea03b63cf68ull;

// pctlプロセスが利用するサーバーの基本URL
static const char ServerEndpoint[] = "https://api-%.pctl.srv.nintendo.net";

// FindDeviceWithPairingCode で利用するURLの書式[Method: GET]
static const size_t MaxPairingCodeLength = 16; // NULL文字含まず
static const char UrlFormat_FindDeviceWithPairingCode[] = "%s/moon/v1/devices?filter.links.pairingCode.code.$eq=%s";
// バッファーの長さ: std::extent<decltype(UrlFormat_FindDeviceWithPairingCode)>::value - 1 - 4 + std::extent<decltype(ServerEndpoint)>::value - 1 + MaxPairingCodeLength + 1
//   '-1': NULL文字、'4': "%s%s"
static const size_t UrlBufferLength_FindDeviceWithPairingCode =
    std::extent<decltype(UrlFormat_FindDeviceWithPairingCode)>::value + std::extent<decltype(ServerEndpoint)>::value + MaxPairingCodeLength - 5;

// RetrieveOwners で利用するURLの書式[Method: GET]
static const char UrlFormat_RetrieveOwners[] = "%s/moon/v1/devices/%016llx/owners";
// バッファーの長さ: std::extent<decltype(UrlFormat_RetrieveOwners)>::value - 1 - 9 + std::extent<decltype(ServerEndpoint)>::value - 1 + 16 + 1
//   '-1': NULL文字、'9': "%s%016llx"、'16': deviceIdの16進表記
static const size_t UrlBufferLength_RetrieveOwners =
    std::extent<decltype(UrlFormat_RetrieveOwners)>::value + std::extent<decltype(ServerEndpoint)>::value + 6;

// UpdateDevice で利用するURLの書式[Method: POST]
static const char UrlFormat_UpdateDevice[] = "%s/moon/v1/devices/%016llx";
// バッファーの長さ: std::extent<decltype(UrlFormat_UpdateDevice)>::value - 1 - 9 + std::extent<decltype(ServerEndpoint)>::value - 1 + 16 + 1
//   '-1': NULL文字、'9': "%s%016llx"、'16': deviceIdの16進表記
static const size_t UrlBufferLength_UpdateDevice =
    std::extent<decltype(UrlFormat_UpdateDevice)>::value + std::extent<decltype(ServerEndpoint)>::value + 6;

// ActivateDevice で利用するURLの書式[Method: POST]
static const char UrlFormat_ActivateDevice[] = "%s/moon/v1/devices/%016llx/activate";
// バッファーの長さ: std::extent<decltype(UrlFormat_ActivateDevice)>::value - 1 - 9 + std::extent<decltype(ServerEndpoint)>::value - 1 + 16 + 1
//   '-1': NULL文字、'9': "%s%016llx"、'16': deviceIdの16進表記
static const size_t UrlBufferLength_ActivateDevice =
    std::extent<decltype(UrlFormat_ActivateDevice)>::value + std::extent<decltype(ServerEndpoint)>::value + 6;

// OnlineCheck で利用するURLの書式[Method: POST]
// URLは UrlFormat_UpdateDevice と同じ
static const char* UrlFormat_OnlineCheck = UrlFormat_UpdateDevice;
static const size_t UrlBufferLength_OnlineCheck = UrlBufferLength_UpdateDevice;

// RetrieveSettings で利用するURLの書式[Method: GET]
static const char UrlFormat_RetrieveSettings[] = "%s/moon/v1/devices/%016llx/parental_control_setting";
// バッファーの長さ: std::extent<decltype(UrlFormat_RetrieveSettings)>::value - 1 - 9 + std::extent<decltype(ServerEndpoint)>::value - 1 + 16 + 1
//   '-1': NULL文字、'9': "%s%016llx"、'16': deviceIdの16進表記
static const size_t UrlBufferLength_RetrieveSettings =
    std::extent<decltype(UrlFormat_RetrieveSettings)>::value + std::extent<decltype(ServerEndpoint)>::value + 6;

// RetrieveSettings で利用するURLの書式[Method: POST]
static const char UrlFormat_RequestUpdateExemptionList[] = "%s/moon/v1/devices/%016llx/parental_control_setting/whitelisted_applications";
// バッファーの長さ: std::extent<decltype(RequestUpdateExemptionList)>::value - 1 - 9 + std::extent<decltype(ServerEndpoint)>::value - 1 + 16 + 1
//   '-1': NULL文字、'9': "%s%016llx"、'16': deviceIdの16進表記
static const size_t UrlBufferLength_RequestUpdateExemptionList =
    std::extent<decltype(UrlFormat_RequestUpdateExemptionList)>::value + std::extent<decltype(ServerEndpoint)>::value + 6;

// UploadSettings で利用するURLの書式[Method: POST]
// URLは UrlFormat_RetrieveSettings と同じ
static const char* UrlFormat_UploadSettings = UrlFormat_RetrieveSettings;
static const size_t UrlBufferLength_UploadSettings = UrlBufferLength_RetrieveSettings;

// UnlinkDevice で利用するURLの書式[Method: DELETE]
static const char UrlFormat_UnlinkDevice[] = "%s/moon/v1/devices/%016llx/owners/%016llx";
// バッファーの長さ: std::extent<decltype(UrlFormat_UnlinkDevice)>::value - 1 - 16 + std::extent<decltype(ServerEndpoint)>::value - 1 + 16 * 2 + 1
//   '-1': NULL文字、'16': "%s%016llx%016llx"、'16 * 2': deviceId・nintendoAccountIdの16進表記
static const size_t UrlBufferLength_UnlinkDevice =
    std::extent<decltype(UrlFormat_UnlinkDevice)>::value + std::extent<decltype(ServerEndpoint)>::value + 15;

// UploadDeviceEvents で利用するURLの書式[Method: POST]
static const char UrlFormat_UploadDeviceEvents[] = "%s/moon/v1/devices/%016llx/events";
// バッファーの長さ: std::extent<decltype(UrlFormat_UploadDeviceEvents)>::value - 1 - 9 + std::extent<decltype(ServerEndpoint)>::value - 1 + 16 + 1
//   '-1': NULL文字、'9': "%s%016llx"、'16': deviceIdの16進表記
static const size_t UrlBufferLength_UploadDeviceEvents =
    std::extent<decltype(UrlFormat_UploadDeviceEvents)>::value + std::extent<decltype(ServerEndpoint)>::value + 6;

// Device Players の更新で利用するURLの書式[Method: PUT/DELETE]
static const char UrlFormat_DevicePlayers[] = "%s/moon/v1/devices/%016llx/players/";
// バッファーの長さ(最低): std::extent<decltype(UrlFormat_DevicePlayers)>::value - 1 - 9 + std::extent<decltype(ServerEndpoint)>::value - 1 + 16 + 1
//   '-1': NULL文字、'9': "%s%016llx"、'16': deviceIdの16進表記
// ※ この文字列の末尾に Uid の文字列表現が加わる
static const size_t UrlBufferLength_DevicePlayers =
    std::extent<decltype(UrlFormat_DevicePlayers)>::value + std::extent<decltype(ServerEndpoint)>::value + 6;

}}}}
