﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_StaticAssert.h>
#include <nn/pctl/detail/service/pctl_ApplicationStateManager.h>
#include <nn/time/time_PosixTime.h>

namespace nn { namespace pctl { namespace detail { namespace service {

struct ParentalControlStates
{
    // 制限がかけられており、かつ一時解除状態を用いて制限チェックを通過した直近のアプリケーション
    // (current: 起動中、next: これから起動)
    nn::ncm::ApplicationId nextApplicationId;
    PctlApplicationInfo currentApplicationInfo;
    nn::ncm::ApplicationId applicationIdFromPdmEvent;
    nn::time::PosixTime applicationLaunchTimeReal;
    bool isApplicationLaunchTimeValid;
    bool isApplicationSuspended;
    bool temporaryUnlocked;
    // UGC利用確認を通過したかどうか
    bool freeCommunicationUsed;
    // StereoVision利用確認を通過したかどうか
    bool stereoVisionUsed;
    int restrictedSystemSettingsEnterCount;
};
NN_STATIC_ASSERT(std::is_pod<ParentalControlStates>::value);

}}}}
