﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_StaticAssert.h>
#include <nn/account/account_Types.h>
#include <nn/ncm/ncm_ContentMetaId.h>
#include <nn/ns/ns_ApplicationManagerApi.h>
#include <nn/time/time_PosixTime.h>
#include <nn/util/util_Optional.h>

namespace nn { namespace pctl { namespace detail { namespace service {

struct PctlApplicationInfo
{
    nn::Bit64 processId;
    nn::ncm::ApplicationId applicationId;
    decltype(nn::ns::ApplicationControlProperty::ratingAge) ratingAge;
    decltype(nn::ns::ApplicationControlProperty::parentalControlFlag) parentalControlFlag;
    int capability;
};

class ApplicationStateManager
{
public:
    static void SetCurrentApplicationInfo(const PctlApplicationInfo& pctlApplicationInfo) NN_NOEXCEPT;
    static void ClearCurrentApplicationInfo(const PctlApplicationInfo& pctlApplicationInfo) NN_NOEXCEPT;

    static bool GetCurrentApplicationInfo(nn::ncm::ApplicationId* outRunningApplication) NN_NOEXCEPT;

    static void SkipAllPlayDataBasedEvents(bool readWithoutPairing) NN_NOEXCEPT
    {
        RecordPlayDataBasedEventsImpl(true, readWithoutPairing);
    }
    static void RecordPlayDataBasedEvents() NN_NOEXCEPT
    {
        RecordPlayDataBasedEventsImpl(false, false);
    }
    static void SetRestrictionTemporaryUnlocked() NN_NOEXCEPT;
    static void UnsetRestrictionTemporaryUnlocked() NN_NOEXCEPT;

    static void AddApplicationLaunchEvent(nn::ncm::ApplicationId applicationId) NN_NOEXCEPT;
    static void AddApplicationTerminateEvent(nn::ncm::ApplicationId applicationId, nn::util::optional<nn::time::PosixTime> timestamp) NN_NOEXCEPT;
    static void AddApplicationRejectEvent(nn::ncm::ApplicationId applicationId) NN_NOEXCEPT;

private:
    static void AddApplicationSuspendEvent(nn::ncm::ApplicationId applicationId, nn::time::PosixTime timestampPdm) NN_NOEXCEPT;
    static void AddApplicationResumeEvent(nn::ncm::ApplicationId applicationId, nn::time::PosixTime timestampPdm) NN_NOEXCEPT;

    static void AddUserOpenEvent(const nn::account::Uid& uid, nn::time::PosixTime timestampPdm) NN_NOEXCEPT;
    static void AddUserCloseEvent(const nn::account::Uid& uid, nn::time::PosixTime timestampPdm) NN_NOEXCEPT;

    static void RecordPlayDataBasedEventsImpl(bool readWithoutRecord, bool readWithoutPairing) NN_NOEXCEPT;
    static void RecordPlayDataBasedApplicationEvents(uint32_t& eventOffset, bool readWithoutRecord) NN_NOEXCEPT;
    static void RecordPlayDataBasedAccountEvents(uint32_t& eventOffset, bool readWithoutRecord) NN_NOEXCEPT;
};

}}}}
