﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/ns/ns_ApplicationManagerApi.h>
#include <nn/pctl/detail/service/common/pctl_SystemInfoTypes.h>
#include <nn/settings/settings_Language.h>
#include <nn/time/time_PosixTime.h>

namespace nn { namespace pctl { namespace detail { namespace service { namespace common {

// @brief 現在のシステム設定における言語の定数値を取得します。
// @return 取得できた場合は true
bool GetSystemLanguage(nn::settings::Language* outLanguage) NN_NOEXCEPT;

// @brief 現在のシステム設定から既定のレーティング団体を取得します。
nn::ns::RatingOrganization GetDefaultRatingOrganizationFromSystemSettings() NN_NOEXCEPT;

// @brief 現在のネットワーク時計時刻を秒単位の整数値で取得します。
// @return 時計が有効であれば true
bool GetNetworkTime(nn::time::PosixTime* outTime) NN_NOEXCEPT;

// @brief デバッグ/テスト用にネットワーク時計時刻を上書きします(GetNetworkTime の戻り値を捻じ曲げます)。
// @details isEnabled を false にすると上書きを無効にして通常の時刻が利用されるようにします。
void SetNetworkTimeForDebug(bool isEnabled, nn::time::PosixTime timeSeconds) NN_NOEXCEPT;

// @brief システムバージョンの数値を取得します。
uint32_t GetSystemVersion() NN_NOEXCEPT;

// @brief システムバージョンの数値と表記文字列を取得します。
uint32_t GetSystemVersion(char (& systemVersionString)[MaxSystemVersionStringLength]) NN_NOEXCEPT;

}}}}}
