﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

namespace nn { namespace pctl { namespace detail {

#if defined(NN_SDK_BUILD_DEBUG) || defined(NN_SDK_BUILD_DEVELOP)
nn::Result AbortIfUnexpectResultImpl(nn::Result result, const char* functionName) NN_NOEXCEPT;
void HandleResultImpl(nn::Result result, bool isShowError, const char* functionName) NN_NOEXCEPT;

inline nn::Result AbortIfUnexpectResult(nn::Result result, const char* functionName) NN_NOEXCEPT
{
    return AbortIfUnexpectResultImpl(result, functionName);
}

inline void HandleResult(nn::Result result, bool isShowError, const char* functionName) NN_NOEXCEPT
{
    return HandleResultImpl(result, isShowError, functionName);
}
#else
nn::Result AbortIfUnexpectResultImpl(nn::Result result) NN_NOEXCEPT;
void HandleResultImpl(nn::Result result, bool isShowError) NN_NOEXCEPT;

inline nn::Result AbortIfUnexpectResult(nn::Result result, const char* functionName) NN_NOEXCEPT
{
    NN_UNUSED(functionName);
    return AbortIfUnexpectResultImpl(result);
}

inline void HandleResult(nn::Result result, bool isShowError, const char* functionName) NN_NOEXCEPT
{
    NN_UNUSED(functionName);
    return HandleResultImpl(result, isShowError);
}
#endif

// @brief 失敗かつ予期しない Result の場合は NN_ABORT を行います。
// @return result で指定された値
#define NN_PCTL_DETAIL_ABORT_IF_UNEXPECTED_RESULT(result) \
    ::nn::pctl::detail::AbortIfUnexpectResult((result), NN_CURRENT_FUNCTION_NAME)

// @brief Result のハンドリングを行い、失敗を示す Result であればエラービューアー表示か NN_ABORT を行います。
#define NN_PCTL_DETAIL_HANDLE_RESULT(result, isShowError) \
    ::nn::pctl::detail::HandleResult((result), (isShowError), NN_CURRENT_FUNCTION_NAME)

}}}
