﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Abort.h>
#include <nn/lmem/lmem_ExpHeap.h>
#include <nn/sf/impl/sf_ExpHeapAllocator.h>

#include <nn/pcm/pcm_IManager.sfdl.h> // for IManager

namespace nn { namespace pcm {

// IManager 実装クラス
class ManagerImpl
    : public nn::sf::ISharedObject
{

public:

    ManagerImpl() NN_NOEXCEPT;
    ~ManagerImpl() NN_NOEXCEPT;
    nn::Result IsServiceEnabled(nn::sf::Out<bool> pOutIsServiceEnabled) NN_NOEXCEPT;
    nn::Result IsSupported(nn::sf::Out<bool> pOutIsSupported, std::int32_t point) NN_NOEXCEPT;
    nn::Result ReadCurrentPower(nn::sf::Out<int> pOutPower, std::int32_t point) NN_NOEXCEPT;
    nn::Result ReadCurrentVoltage(nn::sf::Out<int> pOutVoltage, std::int32_t point) NN_NOEXCEPT;

private:
};

}}
