﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
 * @file
 * @brief   Identifiers for standard PCI class, vendor and
 *          devices (C++ language)
 */

namespace nn { namespace pcie {

/**
 * @brief Base class code definitions for well known types of devices.
 */
const BaseClassCode BaseClassCodeNotDefined       = 0x00;
const BaseClassCode BaseClassCodeStorage          = 0x01;
const BaseClassCode BaseClassCodeNetwork          = 0x02;
const BaseClassCode BaseClassCodeDisplay          = 0x03;
const BaseClassCode BaseClassCodeMultimedia       = 0x04;
const BaseClassCode BaseClassCodeMemory           = 0x05;
const BaseClassCode BaseClassCodeBridge           = 0x06;
const BaseClassCode BaseClassCodeCommunication    = 0x07;
const BaseClassCode BaseClassCodeSystem           = 0x08;
const BaseClassCode BaseClassCodeInput            = 0x09;
const BaseClassCode BaseClassCodeDocking          = 0x0a;
const BaseClassCode BaseClassCodeProcessor        = 0x0b;
const BaseClassCode BaseClassCodeSerial           = 0x0c;
const BaseClassCode BaseClassCodeWireless         = 0x0d;
const BaseClassCode BaseClassCodeIntelligent      = 0x0e;
const BaseClassCode BaseClassCodeSatellite        = 0x0f;
const BaseClassCode BaseClassCodeCrypt            = 0x10;
const BaseClassCode BaseClassCodeSignalprocessing = 0x11;
const BaseClassCode BaseClassCodeOthers           = 0xff;

/**
 * @brief Sub class code definitions.
 */
const SubClassCode SubClassCodeNotDefined         = 0x00;


/**
 * @brief Full class codes
 */
const ClassCode BridgeHostClassCode = 0x0600;
const ClassCode PciBridgeClassCode  = 0x0604;


} // namespace pcie
} // namespace nn


