﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

/**
    @file
    @brief      pcie モジュール用の、ログを出力する API の宣言です。
*/

#include <nn/nn_Common.h>
#include <nn/diag/detail/diag_DetailStructuredSdkLog.h>

#define NN_DETAIL_PCIE_TRACE(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(pcie, Trace, 0, ##__VA_ARGS__)
#define NN_DETAIL_PCIE_TRACE_V1(...)                NN_DETAIL_STRUCTURED_SDK_LOG(pcie, Trace, 1, ##__VA_ARGS__)
#define NN_DETAIL_PCIE_TRACE_V2(...)                NN_DETAIL_STRUCTURED_SDK_LOG(pcie, Trace, 2, ##__VA_ARGS__)
#define NN_DETAIL_PCIE_TRACE_V3(...)                NN_DETAIL_STRUCTURED_SDK_LOG(pcie, Trace, 3, ##__VA_ARGS__)

#define NN_DETAIL_PCIE_INFO(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(pcie, Info, 0, ##__VA_ARGS__)
#define NN_DETAIL_PCIE_INFO_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(pcie, Info, 1, ##__VA_ARGS__)
#define NN_DETAIL_PCIE_INFO_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(pcie, Info, 2, ##__VA_ARGS__)
#define NN_DETAIL_PCIE_INFO_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(pcie, Info, 3, ##__VA_ARGS__)

#define NN_DETAIL_PCIE_WARN(...)                    NN_DETAIL_STRUCTURED_SDK_LOG(pcie, Warn, 0, ##__VA_ARGS__)
#define NN_DETAIL_PCIE_WARN_V1(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(pcie, Warn, 1, ##__VA_ARGS__)
#define NN_DETAIL_PCIE_WARN_V2(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(pcie, Warn, 2, ##__VA_ARGS__)
#define NN_DETAIL_PCIE_WARN_V3(...)                 NN_DETAIL_STRUCTURED_SDK_LOG(pcie, Warn, 3, ##__VA_ARGS__)

#define NN_DETAIL_PCIE_ERROR(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(pcie, Error, 0, ##__VA_ARGS__)
#define NN_DETAIL_PCIE_ERROR_V1(...)                NN_DETAIL_STRUCTURED_SDK_LOG(pcie, Error, 1, ##__VA_ARGS__)
#define NN_DETAIL_PCIE_ERROR_V2(...)                NN_DETAIL_STRUCTURED_SDK_LOG(pcie, Error, 2, ##__VA_ARGS__)
#define NN_DETAIL_PCIE_ERROR_V3(...)                NN_DETAIL_STRUCTURED_SDK_LOG(pcie, Error, 3, ##__VA_ARGS__)

#define NN_DETAIL_PCIE_FATAL(...)                   NN_DETAIL_STRUCTURED_SDK_LOG(pcie, Fatal, 0, ##__VA_ARGS__)
#define NN_DETAIL_PCIE_FATAL_V1(...)                NN_DETAIL_STRUCTURED_SDK_LOG(pcie, Fatal, 1, ##__VA_ARGS__)
#define NN_DETAIL_PCIE_FATAL_V2(...)                NN_DETAIL_STRUCTURED_SDK_LOG(pcie, Fatal, 2, ##__VA_ARGS__)
#define NN_DETAIL_PCIE_FATAL_V3(...)                NN_DETAIL_STRUCTURED_SDK_LOG(pcie, Fatal, 3, ##__VA_ARGS__)

#define NN_DETAIL_PCIE_VTRACE(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(pcie, Trace, 0, format, args)
#define NN_DETAIL_PCIE_VTRACE_V1(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(pcie, Trace, 1, format, args)
#define NN_DETAIL_PCIE_VTRACE_V2(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(pcie, Trace, 2, format, args)
#define NN_DETAIL_PCIE_VTRACE_V3(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(pcie, Trace, 3, format, args)

#define NN_DETAIL_PCIE_VINFO(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(pcie, Info, 0, format, args)
#define NN_DETAIL_PCIE_VINFO_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(pcie, Info, 1, format, args)
#define NN_DETAIL_PCIE_VINFO_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(pcie, Info, 2, format, args)
#define NN_DETAIL_PCIE_VINFO_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(pcie, Info, 3, format, args)

#define NN_DETAIL_PCIE_VWARN(format, args)          NN_DETAIL_STRUCTURED_SDK_VLOG(pcie, Warn, 0, format, args)
#define NN_DETAIL_PCIE_VWARN_V1(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(pcie, Warn, 1, format, args)
#define NN_DETAIL_PCIE_VWARN_V2(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(pcie, Warn, 2, format, args)
#define NN_DETAIL_PCIE_VWARN_V3(format, args)       NN_DETAIL_STRUCTURED_SDK_VLOG(pcie, Warn, 3, format, args)

#define NN_DETAIL_PCIE_VERROR(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(pcie, Error, 0, format, args)
#define NN_DETAIL_PCIE_VERROR_V1(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(pcie, Error, 1, format, args)
#define NN_DETAIL_PCIE_VERROR_V2(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(pcie, Error, 2, format, args)
#define NN_DETAIL_PCIE_VERROR_V3(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(pcie, Error, 3, format, args)

#define NN_DETAIL_PCIE_VFATAL(format, args)         NN_DETAIL_STRUCTURED_SDK_VLOG(pcie, Fatal, 0, format, args)
#define NN_DETAIL_PCIE_VFATAL_V1(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(pcie, Fatal, 1, format, args)
#define NN_DETAIL_PCIE_VFATAL_V2(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(pcie, Fatal, 2, format, args)
#define NN_DETAIL_PCIE_VFATAL_V3(format, args)      NN_DETAIL_STRUCTURED_SDK_VLOG(pcie, Fatal, 3, format, args)

#define NN_DETAIL_PCIE_PUT_TRACE(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(pcie, Trace, 0, text, length)
#define NN_DETAIL_PCIE_PUT_TRACE_V1(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(pcie, Trace, 1, text, length)
#define NN_DETAIL_PCIE_PUT_TRACE_V2(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(pcie, Trace, 2, text, length)
#define NN_DETAIL_PCIE_PUT_TRACE_V3(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(pcie, Trace, 3, text, length)

#define NN_DETAIL_PCIE_PUT_INFO(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(pcie, Info, 0, text, length)
#define NN_DETAIL_PCIE_PUT_INFO_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(pcie, Info, 1, text, length)
#define NN_DETAIL_PCIE_PUT_INFO_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(pcie, Info, 2, text, length)
#define NN_DETAIL_PCIE_PUT_INFO_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(pcie, Info, 3, text, length)

#define NN_DETAIL_PCIE_PUT_WARN(text, length)       NN_DETAIL_STRUCTURED_SDK_PUT(pcie, Warn, 0, text, length)
#define NN_DETAIL_PCIE_PUT_WARN_V1(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(pcie, Warn, 1, text, length)
#define NN_DETAIL_PCIE_PUT_WARN_V2(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(pcie, Warn, 2, text, length)
#define NN_DETAIL_PCIE_PUT_WARN_V3(text, length)    NN_DETAIL_STRUCTURED_SDK_PUT(pcie, Warn, 3, text, length)

#define NN_DETAIL_PCIE_PUT_ERROR(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(pcie, Error, 0, text, length)
#define NN_DETAIL_PCIE_PUT_ERROR_V1(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(pcie, Error, 1, text, length)
#define NN_DETAIL_PCIE_PUT_ERROR_V2(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(pcie, Error, 2, text, length)
#define NN_DETAIL_PCIE_PUT_ERROR_V3(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(pcie, Error, 3, text, length)

#define NN_DETAIL_PCIE_PUT_FATAL(text, length)      NN_DETAIL_STRUCTURED_SDK_PUT(pcie, Fatal, 0, text, length)
#define NN_DETAIL_PCIE_PUT_FATAL_V1(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(pcie, Fatal, 1, text, length)
#define NN_DETAIL_PCIE_PUT_FATAL_V2(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(pcie, Fatal, 2, text, length)
#define NN_DETAIL_PCIE_PUT_FATAL_V3(text, length)   NN_DETAIL_STRUCTURED_SDK_PUT(pcie, Fatal, 3, text, length)
