﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_ApplicationId.h>
#include <nn/account/account_Types.h>
#include <nn/fs/fs_SaveDataManagement.h>
#include <nn/fs/fs_SaveDataManagementPrivate.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_Optional.h>

namespace nn { namespace olsc { namespace srv { namespace util {

template <typename Pred>
nn::util::optional<nn::fs::SaveDataInfo> FindSaveData(nn::fs::SaveDataSpaceId spaceId, Pred pred) NN_NOEXCEPT
{
    std::unique_ptr<nn::fs::SaveDataIterator> iter;
    NN_ABORT_UNLESS_RESULT_SUCCESS(nn::fs::OpenSaveDataIterator(&iter, spaceId));

    int64_t count;
    nn::fs::SaveDataInfo info;
    while (NN_STATIC_CONDITION(true))
    {
        count = 0;
        NN_ABORT_UNLESS_RESULT_SUCCESS(iter->ReadSaveDataInfo(&count, &info, 1));
        if (count == 0)
        {
            return nn::util::nullopt;
        }

        if (pred(info))
        {
            return info;
        }
    }
}

nn::util::optional<nn::fs::SaveDataInfo> FindSaveData(const account::Uid& uid, ApplicationId appId) NN_NOEXCEPT;

}}}} // nn::olsc::srv::util
