﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>
#include <nn/olsc/srv/database/olsc_TransferTaskDatabaseManager.h>
#include <nn/olsc/srv/olsc_TransferTask.h>
#include <nn/olsc/srv/util/olsc_MountManager.h>
#include <nn/os/os_Thread.h>
#include <nn/os/os_SystemEvent.h>

namespace nn { namespace olsc { namespace srv {

class TransferTaskFactoryBase
{
public:
    // TODO : suspendedInfo を context に統合後削除
    virtual TransferTaskBase * Create(const TransferTaskDetailInfo& detailInfo, const SeriesInfo& lastSi, TransferTaskBase::TransferTaskExecutionResource& executionResource, TransferTaskSuspendedInfo&& suspendedInfo) NN_NOEXCEPT = 0;
    virtual void Destroy(TransferTaskBase* task) NN_NOEXCEPT = 0;
};

class TransferTaskFactory : public TransferTaskFactoryBase
{
    NN_DISALLOW_COPY(TransferTaskFactory);

public:
    using TransferTaskDatabaseManager = database::TransferTaskDatabaseManager;

    NN_IMPLICIT TransferTaskFactory(TransferTaskDatabaseManager& ttdm) NN_NOEXCEPT
        : m_Created(false), m_Ttdm(ttdm)
    {}
    virtual ~TransferTaskFactory() NN_NOEXCEPT
    {
        std::lock_guard<decltype(m_Lock)> lock(m_Lock);
        NN_SDK_REQUIRES(!m_Created);
    }

    // TODO : suspendedInfo を context に統合後削除
    virtual TransferTaskBase* Create(const TransferTaskDetailInfo& detailInfo, const SeriesInfo& lastSi, TransferTaskBase::TransferTaskExecutionResource& executionResource, TransferTaskSuspendedInfo&& suspendedInfo) NN_NOEXCEPT NN_OVERRIDE;
    virtual void Destroy(TransferTaskBase* task) NN_NOEXCEPT NN_OVERRIDE;

private:
    static const size_t TaskStorageSize = sizeof(UploadTransferTask) > sizeof(DownloadTransferTask) ? sizeof(UploadTransferTask) : sizeof(DownloadTransferTask);

    std::aligned_storage<TaskStorageSize>::type m_Storage;
    os::SdkMutex m_Lock;
    bool m_Created;
    TransferTaskDatabaseManager& m_Ttdm;
};


}}} // ~namespace nn::olsc::srv
