﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>
#include <nn/olsc/olsc_Result.h>
#include <nn/olsc/olsc_DataTypes.h>
#include <nn/olsc/olsc_RemoteStorageController.h>
#include <nn/olsc/olsc_TransferTaskTypes.h>
#include <nn/olsc/sfdl/olsc_IOlscService.sfdl.h>
#include <nn/olsc/srv/olsc_SaveDataArchiveInfoCacheManager.h>
#include <nn/olsc/srv/olsc_TransferTask.h>
#include <nn/olsc/srv/olsc_SeriesInfoDatabaseManager.h>
#include <nn/olsc/srv/database/olsc_SaveDataArchiveInfoCache.h>
#include <nn/olsc/srv/database/olsc_TransferTaskDatabaseManager.h>
#include <nn/olsc/srv/util/olsc_MountManager.h>
#include <nn/sf/sf_Buffers.h>
#include <nn/sf/sf_ISharedObject.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/util/util_Execution.h>

namespace nn { namespace olsc { namespace srv {

class RemoteStorageControllerImpl
{
public:
    RemoteStorageControllerImpl(
        MemoryResource& objectMemoryResource,
        database::TransferTaskDatabaseManager& ttdm,
        SeriesInfoDatabaseManager& seriesInfoDatabaseManager,
        SaveDataArchiveInfoCacheManager& sdaInfoCacheManager,
        nn::util::AbstractExecutor& executor,
        util::DefaultMountManager& mountManager)
        : m_ObjectMemoryResource(objectMemoryResource)
        , m_Ttdm(ttdm)
        , m_SdaInfoCacheManager(sdaInfoCacheManager)
        , m_SeriesInfoDatabaseManager(seriesInfoDatabaseManager)
        , m_Executor(executor)
    {
    }

    Result RegisterUploadSaveDataTransferTask(sf::Out<TransferTaskId> outValue, const account::Uid& uid, ApplicationId appId) NN_NOEXCEPT;
    Result RegisterDownloadSaveDataTransferTask(sf::Out<TransferTaskId> outValue, const account::Uid& uid, DataId dataId) NN_NOEXCEPT;


    Result ListDataInfo(sf::Out<int32_t> outValue, const nn::sf::OutBuffer& outBuffer, int count, const account::Uid& uid, int offset) const NN_NOEXCEPT;
    Result GetCount(sf::Out<int32_t> outValue, const account::Uid& uid) const NN_NOEXCEPT;
    Result GetDataInfo(sf::Out<bool> outValue, sf::Out<DataInfo> outBuffer, const account::Uid& uid, ApplicationId appId)  const NN_NOEXCEPT;
    Result DeleteDataInfo(const account::Uid& uid, DataId dataId) NN_NOEXCEPT;
    Result GetDataNewness(sf::Out<DataNewness> outValue, const account::Uid& uid, DataId dataId) const NN_NOEXCEPT;

    Result ClearDataInfoCache(const account::Uid& uid) NN_NOEXCEPT;

    Result RequestUpdateDataInfoCacheAsync(sf::Out<sf::SharedPointer<IAsyncResult>> outValue, const nn::account::Uid& uid) NN_NOEXCEPT;
    Result RequestUpdateDataInfoCacheOfSpecifiedApplicationAsync(sf::Out<sf::SharedPointer<IAsyncResult>> outValue, const nn::account::Uid& uid, ApplicationId appId) NN_NOEXCEPT;
    Result RequestDeleteData(sf::Out<sf::SharedPointer<IAsyncResult>> outValue, const nn::account::Uid& uid, DataId dataId) NN_NOEXCEPT;

private:
    MemoryResource& m_ObjectMemoryResource;
    database::TransferTaskDatabaseManager& m_Ttdm;
    SaveDataArchiveInfoCacheManager& m_SdaInfoCacheManager;
    SeriesInfoDatabaseManager& m_SeriesInfoDatabaseManager;
    nn::util::AbstractExecutor& m_Executor;
};

}}} // namespace nn::olsc::srv
