﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Allocator.h>
#include <nn/nn_Result.h>
#include <nn/olsc/sfdl/olsc_IOlscService.sfdl.h>
#include <nn/olsc/srv/olsc_AutoUploadSettingManager.h>
#include <nn/olsc/srv/database/olsc_TransferTaskDatabaseManager.h>
#include <nn/sf/sf_Out.h>

namespace nn { namespace olsc { namespace srv {

class DaemonControllerImpl
{
public:
    DaemonControllerImpl(
        MemoryResource& objectMemoryResource,
        AutoUploadSettingManager& autoUploadSettingManager,
        database::TransferTaskDatabaseManager& ttdm) NN_NOEXCEPT
        : m_ObjectMemoryResource(objectMemoryResource)
        , m_AutoUploadSettingManager(autoUploadSettingManager)
        , m_Ttdm(ttdm)
    {}
    Result GetApplicationAutoUploadSetting(sf::Out<bool> outValue, const account::Uid& uid, ApplicationId appId) const NN_NOEXCEPT;
    Result SetApplicationAutoUploadSetting(const account::Uid& uid, ApplicationId appId, bool isEnabled) NN_NOEXCEPT;
    Result GetGlobalAutoUploadSetting(sf::Out<bool> outValue, const account::Uid& uid) const NN_NOEXCEPT;
    Result SetGlobalAutoUploadSetting(const account::Uid& uid, bool isEnabled) NN_NOEXCEPT;

    Result CreateForbiddenSaveDataInidication(sf::Out<sf::SharedPointer<IForbiddenSaveDataIndication>> pOut, ApplicationId appId) NN_NOEXCEPT;

    void DeleteAllApplicationSetting(const account::Uid& uid) NN_NOEXCEPT;

private:
    // TODO: NotSet を全体設定の値と同じ扱いにするというポリシーは
    //       ここだけでなく、BG の自律処理でも使用するので、その辺実装時にこの実装を正しい場所に移す
    bool GetApplicationAutoUploadEnabledImpl(const account::Uid& uid, ApplicationId appId) const NN_NOEXCEPT;

    MemoryResource& m_ObjectMemoryResource;
    AutoUploadSettingManager& m_AutoUploadSettingManager;
    database::TransferTaskDatabaseManager& m_Ttdm;
};

}}} // namespace nn::olsc::srv
