﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/olsc/olsc_Result.h>
#include <nn/os/os_SystemEvent.h>

/**
 *  @file
 *  @brief  非同期リクエスト
 */

namespace nn { namespace olsc {
    namespace srv {
        class IAsyncResult;
    }
/**
*   @brief  非同期リクエストを扱うためのオブジェクトです。
*/
class AsyncRequest {
    NN_DISALLOW_COPY(AsyncRequest);

public:
    AsyncRequest() NN_NOEXCEPT;
    NN_IMPLICIT AsyncRequest(srv::IAsyncResult* asyncResult) NN_NOEXCEPT;
    ~AsyncRequest() NN_NOEXCEPT;

    AsyncRequest(AsyncRequest&& rhs) NN_NOEXCEPT;
    AsyncRequest& operator=(AsyncRequest&& rhs) NN_NOEXCEPT;

    /**
    *   @brief  実行中のリクエストにキャンセルを要求を出します。
    */
    void Cancel() NN_NOEXCEPT;

    /**
    *   @brief  実行中のリクエストが完了、またはキャンセルされた場合にシグナルされる手動イベントを取得します。
    */
    void GetEvent(os::SystemEvent* out) NN_NOEXCEPT;

    /**
    *   @brief  実行中のリクエストの処理結果を取得します。
    */
    Result GetResult() NN_NOEXCEPT;

private:
    friend void swap(AsyncRequest& lhs, AsyncRequest& rhs) NN_NOEXCEPT;
    srv::IAsyncResult* m_AsyncResult;
};

void swap(AsyncRequest& lhs, AsyncRequest& rhs) NN_NOEXCEPT;

}} // namespace nn::olsc
