﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/ntc/detail/service/ntc_Common.h>
#include <nn/ntc/detail/service/ntc_IEnsureNetworkClockAvailabilityService.sfdl.h>
#include <nn/ntc/detail/service/core/ntc_SerializeTaskThread.h>
#include <nn/nifm/nifm_ApiClientManagement.h>

namespace nn { namespace ntc { namespace detail { namespace service {

class EnsureNetworkClockAvailabilityServiceBase
{
NN_DISALLOW_COPY(EnsureNetworkClockAvailabilityServiceBase);
NN_DISALLOW_MOVE(EnsureNetworkClockAvailabilityServiceBase);

public:
    EnsureNetworkClockAvailabilityServiceBase(core::TaskExecutor* m_pTaskExecutor, const nn::nifm::ClientId& nifmClientId) NN_NOEXCEPT;

    virtual ~EnsureNetworkClockAvailabilityServiceBase() NN_NOEXCEPT;

    nn::Result GetSystemEventReadableHandle(nn::sf::Out<nn::sf::NativeHandle> outEvent) NN_NOEXCEPT;

    nn::Result StartTask() NN_NOEXCEPT;

    nn::Result GetResult() NN_NOEXCEPT;

    nn::Result Cancel() NN_NOEXCEPT;

    nn::Result IsProcessing(nn::sf::Out<bool> outIsProcessing) NN_NOEXCEPT;

    virtual nn::Result GetServerTime(nn::sf::Out<nn::time::PosixTime> outServerTime) NN_NOEXCEPT;

private:
    //!< スレッドタスク用リソース
    core::TaskResource m_TaskResource;
    core::TaskResourceNode m_TaskResourceNode;

    const nn::nifm::ClientId m_NifmClientId;
};

// EnsureNetworkClockAvailabilityMode_Default 向けサービス
class DefaultEnsureNetworkClockAvailabilityService : public EnsureNetworkClockAvailabilityServiceBase
{
public:
    explicit DefaultEnsureNetworkClockAvailabilityService(const nn::nifm::ClientId& nifmClientId) NN_NOEXCEPT;
};

// EnsureNetworkClockAvailabilityMode_ForcibleDownload 向けサービス
class ForcibleDownloadEnsureNetworkClockAvailabilityService : public EnsureNetworkClockAvailabilityServiceBase
{
public:
    explicit ForcibleDownloadEnsureNetworkClockAvailabilityService(const nn::nifm::ClientId& nifmClientId) NN_NOEXCEPT;
};

// EnsureNetworkClockAvailabilityMode_GetServerTime 向けサービス
class ServerTimeGetterService : public EnsureNetworkClockAvailabilityServiceBase
{
public:
    explicit ServerTimeGetterService(const nn::nifm::ClientId& nifmClientId) NN_NOEXCEPT;
    virtual nn::Result GetServerTime(nn::sf::Out<nn::time::PosixTime> outServerTime) NN_NOEXCEPT;
};

}}}} // nn::ntc::detail::service
