﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

/**
 * @file
 * @brief IPC サーバ向けの nn::nsd::server API
 */

#pragma once

#include <nn/nsd/nsd_Common.h>

namespace nn { namespace nsd { namespace server {

    /**
     * @brief サービスディスカバリの IPC サーバを起動します。
     *
     * @return  処理の結果が返ります。
     * @retval  ResultSuccess       成功しました。
     *
     * @details
     *  サービスディスカバリの IPC サーバを起動します。
     *
     *  IPC サーバの停止は @ref nn::nsd::nsdsrv::StopServert() で行ってください。
     */
     nn::Result StartServer() NN_NOEXCEPT;

    /**
     * @brief サービスディスカバリの IPC サーバを停止します。
     *
     * @return  処理の結果が返ります。
     * @retval  ResultSuccess       成功しました。
     *
     * @details
     *  @ref nn::nsd::nsdsrv::StartServer() で起動された
     *  サービスディスカバリの IPC サーバを停止します。
     */
     nn::Result StopServer() NN_NOEXCEPT;

}}} // nn::nsd::server
