﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nsd/detail/nsd_IManager.sfdl.h>
#include <nn/nsd/nsd_TypesPrivate.h>

namespace nn { namespace nsd { namespace detail { namespace server {

class ManagerImpl
{
public:
    ManagerImpl() NN_NOEXCEPT
        : m_ServiceType(nn::nsd::ServiceType_User)
    {}

    explicit ManagerImpl( nn::nsd::ServiceType serviceType ) NN_NOEXCEPT
        : m_ServiceType( serviceType )
    {}

    ~ManagerImpl() NN_NOEXCEPT
    {}

public:
    nn::Result GetSettingName(nn::sf::Out<nn::nsd::SettingName> pOut) NN_NOEXCEPT;
    nn::Result GetEnvironmentIdentifier(nn::sf::Out<nn::nsd::EnvironmentIdentifier> pOut) NN_NOEXCEPT;
    nn::Result GetDeviceId(nn::sf::Out<nn::nsd::DeviceId> pOut) NN_NOEXCEPT;
    nn::Result DeleteSettings(const int32_t deleteModeValue) NN_NOEXCEPT;
    nn::Result ImportSettings(const nn::sf::InBuffer& pBuffer, const nn::sf::OutBuffer& pWorkBuffer, const int32_t importModeValue) NN_NOEXCEPT;
    nn::Result Resolve(nn::sf::Out<nn::nsd::Fqdn> pOut, const nn::nsd::Fqdn& fqdn) NN_NOEXCEPT;
    nn::Result ResolveEx(nn::sf::Out<nn::nsd::InnerResult> pInnerResult, nn::sf::Out<nn::nsd::Fqdn> pOut, const nn::nsd::Fqdn& fqdn) NN_NOEXCEPT;
    nn::Result GetNasServiceSetting(nn::sf::Out<nn::nsd::NasServiceSetting> pOutNasServiceSetting, const nn::nsd::NasServiceName& nasServiceName) NN_NOEXCEPT;
    nn::Result GetNasServiceSettingEx(nn::sf::Out<nn::nsd::InnerResult> pInnerResult, nn::sf::Out<nn::nsd::NasServiceSetting> pOutNasServiceSetting, const nn::nsd::NasServiceName& nasServiceName) NN_NOEXCEPT;
    nn::Result GetNasRequestFqdn(nn::sf::Out<nn::nsd::Fqdn> pOut) NN_NOEXCEPT;
    nn::Result GetNasRequestFqdnEx(nn::sf::Out<nn::nsd::InnerResult> pInnerResult, nn::sf::Out<nn::nsd::Fqdn> pOut) NN_NOEXCEPT;
    nn::Result GetNasApiFqdn(nn::sf::Out<nn::nsd::Fqdn> pOut) NN_NOEXCEPT;
    nn::Result GetNasApiFqdnEx(nn::sf::Out<nn::nsd::InnerResult> pInnerResult, nn::sf::Out<nn::nsd::Fqdn> pOut) NN_NOEXCEPT;
    nn::Result GetCurrentSetting(nn::sf::Out<nn::nsd::SaveData> pOut) NN_NOEXCEPT;
    nn::Result WriteSaveDataToFsForTest(const nn::nsd::SaveData& saveData) NN_NOEXCEPT;
    nn::Result ReadSaveDataFromFsForTest(nn::sf::Out<nn::nsd::SaveData> pOut) NN_NOEXCEPT;
    nn::Result DeleteSaveDataOfFsForTest() NN_NOEXCEPT;
    nn::Result SetChangeEnvironmentIdentifierDisabled(bool isDisabled) NN_NOEXCEPT;
    nn::Result IsChangeEnvironmentIdentifierDisabled(nn::sf::Out<bool> outValue) NN_NOEXCEPT;

private:
    // nsd:u か nsd:a により nn::nsd::ServiceType_User か nn::nsd::ServiceType_Admin
    const nn::nsd::ServiceType m_ServiceType;

    bool IsAdminService() const NN_NOEXCEPT
    {
        return (m_ServiceType == nn::nsd::ServiceType_Admin);
    }
};

}}}} // nn::nsd::detail::server
