﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nn { namespace nsd { namespace detail { namespace jwt {

    const char* SignAlgorithm = "RS256"; //!< 署名アルゴリズム

    //!< JWT 署名の公開鍵(係数)
    const uint8_t Modulus[] =
    {
        0xac, 0xf0, 0x5f, 0x30, 0x2b, 0x30, 0x93, 0x95, 0xd2, 0xd4, 0xc6, 0x7f, 0xfa, 0xf6, 0x79, 0x8f,
        0x65, 0xe1, 0x1e, 0x4b, 0x39, 0x3c, 0x72, 0x1b, 0xb2, 0x47, 0x4e, 0x5d, 0x87, 0xca, 0x30, 0xed,
        0x56, 0xf0, 0x25, 0xed, 0xfd, 0x09, 0x66, 0xeb, 0x67, 0xf1, 0x99, 0xb7, 0x51, 0x90, 0xe9, 0x47,
        0x1d, 0xdd, 0x32, 0x5d, 0xc3, 0x10, 0x17, 0xb7, 0x4a, 0x7e, 0x90, 0x8d, 0x12, 0x59, 0xeb, 0xc7,
        0x68, 0xce, 0x83, 0xd7, 0xd4, 0x32, 0xda, 0x4d, 0x32, 0x1f, 0x56, 0xdb, 0x83, 0x94, 0x20, 0x85,
        0x1f, 0x92, 0xcf, 0x19, 0x10, 0x83, 0x42, 0x2b, 0xfd, 0x58, 0x96, 0x71, 0x98, 0x04, 0xcb, 0x62,
        0x36, 0x28, 0xc8, 0x12, 0x2b, 0x5d, 0x37, 0x32, 0xea, 0xf4, 0x2c, 0x8f, 0x4e, 0xc8, 0xa1, 0x66,
        0xad, 0x8b, 0x6b, 0x0f, 0xc0, 0xbf, 0x0f, 0x0c, 0x15, 0x43, 0x64, 0x19, 0xa7, 0xf2, 0x1c, 0xfa,
        0x2f, 0x32, 0xdb, 0x35, 0x83, 0x13, 0x0b, 0x57, 0xd2, 0xe6, 0x9d, 0xb2, 0xf2, 0xdf, 0xf9, 0x2a,
        0xfb, 0x0b, 0xd5, 0xbf, 0xb7, 0x83, 0x52, 0xe7, 0x6f, 0x40, 0xeb, 0x84, 0x4d, 0xea, 0x4f, 0x84,
        0x4a, 0x1b, 0x97, 0x82, 0x95, 0xa1, 0x66, 0x5c, 0x61, 0x75, 0x37, 0x61, 0x5d, 0x9b, 0xdd, 0x19,
        0xe0, 0xaf, 0x20, 0xd1, 0x99, 0xb8, 0x0f, 0x42, 0xd3, 0xd0, 0x0d, 0x72, 0x6a, 0xa2, 0x3a, 0x18,
        0xc6, 0x7f, 0xfb, 0xc2, 0xb2, 0x75, 0xa9, 0x74, 0xd0, 0x51, 0xc8, 0x86, 0x54, 0x79, 0x8f, 0xb5,
        0x54, 0x6c, 0xeb, 0x1b, 0x66, 0x47, 0x15, 0x3a, 0x14, 0x06, 0x66, 0xb0, 0xf0, 0x09, 0x1b, 0xe7,
        0x01, 0x28, 0x42, 0xed, 0xa6, 0x4c, 0x66, 0x63, 0x9b, 0xb9, 0x8a, 0x1f, 0x35, 0xf2, 0x67, 0x90,
        0xe8, 0xc3, 0x96, 0xa2, 0xfd, 0x5b, 0xb5, 0x1b, 0x3b, 0xb4, 0xad, 0x45, 0xce, 0x00, 0xd7, 0x99
    };

    //!< JWT 署名の公開鍵(指数)
    const uint8_t Exponent[] =
    {
        0x01, 0x00, 0x01
    };

}}}} // nn::nsd::detail::jwt

