﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/ncm/ncm_ContentMetaKey.h>
#include <nn/ncm/ncm_ContentMetaId.h>
#include <nn/ns/srv/ns_OsUtil.h>
#include <nn/os/os_Event.h>
#include <nn/os/os_Thread.h>
#include <nn/util/util_Optional.h>

namespace nn { namespace ns { namespace srv {
    enum class ApplicationInstallReportType : Bit8
    {
        Installed,
        UninstalledTemporarily,
        UninstalledCompletely
    };

    enum class SystemUpdateType : Bit8
    {
        Nup,
        Cup,
        Lup,
    };

    class SystemReportManager
    {
    public:
        void Initialize() NN_NOEXCEPT;
        void InitializeForMaintenanceMode() NN_NOEXCEPT;

        void ReportApplicationInstall(ApplicationInstallReportType type, ncm::ApplicationId id) const NN_NOEXCEPT;

        void SetSdCardReportEnabled(bool isOn) NN_NOEXCEPT
        {
            m_IsSdCardReportEnabled = isOn;
        }
        void ReportSdCardInfo() const NN_NOEXCEPT;
        void ReportSdCardFreeSpace() const NN_NOEXCEPT;

        void ReportSystemUpdatePerformance(const ncm::ContentMetaKey& key, int64_t downloadSize, int64_t throughput) const NN_NOEXCEPT;
        void ReportApplicationInstallPerformance(ncm::ApplicationId id, const ncm::ContentMetaKey& key, ncm::StorageId storageId, int64_t downloadSize, int64_t throughput) const NN_NOEXCEPT;

        void ReportSystemUpdate(SystemUpdateType type, uint64_t sourceSystemUpdateMetaId, uint32_t sourceSystemUpdateMetaVersion, uint64_t destinationSystemUpdateMetaId, uint32_t destinationSystemUpdateMetaVersion, bool isExFatSupported, bool isExFatSupportedAfterUpdate, bool isRebootless) const NN_NOEXCEPT;

    private:
        void Run() NN_NOEXCEPT;

        bool m_IsEnabled{};
        bool m_IsSdCardReportEnabled{};
    };

}}} // ~namespace ns::srv

