﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/ns/srv/ns_ApplicationEntityManager.h>
#include <nn/ns/srv/ns_ApplicationRecordDatabase.h>
#include <nn/ns/srv/ns_DataStore.h>
#include <nn/ns/srv/ns_IntegratedContentManager.h>
#include <nn/ns/srv/ns_LockedBufferManager.h>
#include <nn/ns/srv/ns_PushNotificationDisptcher.h>
#include <nn/ns/srv/ns_RequestServer.h>

namespace nn { namespace ns { namespace srv {

    class ShutdownManager
    {
    public:
        ShutdownManager() NN_NOEXCEPT : m_DataStore(), m_RequestServer() {}
        Result Initialize(ApplicationEntityManager* entityManager, DataStore* dataStore, IntegratedContentManager* integrated, RequestServer* requestServer, ApplicationRecordDatabase* recordDb, PushNotificationDispatcher* notificationDispatcher, LockedBufferManager* lockedBufferManager, bool needsCleanup) NN_NOEXCEPT;
        void InitializeForMaintenanceMode() NN_NOEXCEPT;
        Result PrepareShutdown() NN_NOEXCEPT;

    private:
        DataStore* m_DataStore;
        PushNotificationDispatcher* m_PushNotificationDispatcher;
        RequestServer* m_RequestServer;
        RequestServer::ManagedStop m_Stopper;
    };

}}}
