﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/util/util_Optional.h>
#include <nn/os/os_Thread.h>
#include <nn/ns/srv/ns_OsUtil.h>
#include <nn/ns/srv/ns_RequestServer.h>
#include <nn/nifm/nifm_Api.h>

namespace nn { namespace ns { namespace srv {
    class RequestServerManager
    {
    public:
        RequestServerManager(uint8_t* stack, size_t stackSize) NN_NOEXCEPT;

        void Initialize(RequestServer* requestServerForApplicationManager, RequestServer* requestServerForSystemUpdate) NN_NOEXCEPT;
        void Finalize() NN_NOEXCEPT;
    private:
        void Run() NN_NOEXCEPT;

        static const int MaxRequestServerCount = 2;
        RequestServer* m_RequestServerList[MaxRequestServerCount];

        uint8_t* m_Stack;
        size_t m_StackSize;

        os::ThreadType m_Thread;
        ManualClearSystemEvent m_StopEvent;
    };

}}}
