﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

namespace nn { namespace ns {

    const size_t SystemSeedSize = 32;
    struct SystemSeedForPseudoDeviceId
    {
        Bit8 seed[SystemSeedSize];
    };

    void GetSystemSeedForPseudoDeviceId(SystemSeedForPseudoDeviceId* pOutSeed) NN_NOEXCEPT;
    Result ResetSystemSeedForPseudoDeviceId() NN_NOEXCEPT;

}}  // namespace ns
