﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

namespace nn { namespace ns {

    /**
    * @brief    本体初期化します。
    *
    * @details  下記の全てが削除されます。
    *           @li 内蔵ストレージにインストールされているアプリケーション
    *           @li 内蔵ストレージに保存されているスクリーンショット
    *           @li アカウント情報
    *           @li ユーザセーブデータ
    *           @li 一部を除くシステムセーブデータ
    *
    * @pre
    *           - InitializeForApplicationManager() 呼び出し
    */
    void ResetToFactorySettings() NN_NOEXCEPT;

    /**
    * @brief    ユーザのデータを除いて本体初期化します。
    *
    * @details  下記の全てが削除されます。
    *           @li 内蔵ストレージにインストールされているアプリケーション
    *           @li Bcat ストレージ
    *           @li 一部を除くシステムセーブデータ
    *
    * @pre
    *           - InitializeForApplicationManager() 呼び出し
    */
    void ResetToFactorySettingsWithoutUserSaveData() NN_NOEXCEPT;

    /**
    * @brief    リファービッシュ用の本体初期化を行います。
    *           ノーマル本体初期化では削除されないシステムセーブデータの一部が削除されます。
    *
    * @details  下記の全てが削除されます。
    *           @li 内蔵ストレージにインストールされているアプリケーション
    *           @li 内蔵ストレージに保存されているスクリーンショット
    *           @li アカウント情報
    *           @li ユーザセーブデータ
    *           @li 一部を除くシステムセーブデータ
    *
    * @pre
    *           - InitializeForApplicationManager() 呼び出し
    */
    void ResetToFactorySettingsForRefurbishment() NN_NOEXCEPT;

}}
