﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/ncm/ncm_ContentMetaId.h>
#include <nn/ncm/ncm_ContentMetaType.h>
#include <nn/ncm/ncm_ContentMetaKey.h>
#include <nn/ncm/ncm_StorageId.h>
#include <nn/ns/ns_ApplicationContentMetaApi.h>

namespace nn { namespace ns {
    Result ListAvailableAddOnContent(int* outCount, ApplicationContentMetaStatus outList[], int count, ncm::ApplicationId appId, int offset) NN_NOEXCEPT;
    Result GetOwnedApplicationContentMetaStatus(ApplicationContentMetaStatus* outValue, ncm::ApplicationId appId, nn::Bit64 contentMetaId) NN_NOEXCEPT;
    Result RegisterContentsExternalKey(ncm::ApplicationId appId, nn::Bit64 contentMetaId) NN_NOEXCEPT;
    Result GetContentMetaStorage(ncm::StorageId* outValue, const ncm::ContentMetaKey& key) NN_NOEXCEPT;
}}  // namespace nn::ns
