﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/fs/fs_SystemSaveData.h>
#include <nn/kvdb/kvdb_BoundedString.h>
#include <nn/util/util_Optional.h>

namespace nn { namespace nim { namespace srv {

    class TemporaryDataStore
    {
    public:
        typedef kvdb::BoundedString<64> Path;

        ~TemporaryDataStore() NN_NOEXCEPT;

        Result Initialize(const char* mountName, fs::SystemSaveDataId id, int64_t saveDataSize, int64_t saveDataJournalSize, int saveDataFlags) NN_NOEXCEPT;

        Path GenerateTemporaryFilePath() const NN_NOEXCEPT;

    private:
        util::optional<Path> m_MoundName;
    };

}}}
