﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <random>
#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/nim/srv/nim_NetworkInstallTaskBase.h>
#include <nn/nim/nim_SystemUpdateTaskId.h>

namespace nn { namespace nim { namespace srv {

    class NetworkSystemUpdateTask : public NetworkInstallTaskBase
    {
    public:
        Result Initialize(DeviceContext* deviceContext, const ncm::ContentMetaKey& key, Bit32 config, const char* dataFilePath) NN_NOEXCEPT;
        ncm::ContentMetaKey GetKey() const
        {
            return m_Key;
        }
        Result GetDownloadedSystemDataPath(ncm::Path* outValue, ncm::SystemDataId id) NN_NOEXCEPT;
        Result GetApplyInfo(ncm::SystemUpdateTaskApplyInfo* outValue) NN_NOEXCEPT;

    private:
        virtual Result PrepareDependency() NN_NOEXCEPT NN_OVERRIDE;
        virtual int CountInstallContentMetaKey() NN_NOEXCEPT NN_OVERRIDE;
        virtual Result GetInstallContentMetaKey(ncm::ContentMetaKey* outValue, int index) NN_NOEXCEPT NN_OVERRIDE;
        virtual Result InstallTicket(const nn::fs::RightsId& rightsId, nn::ncm::ContentMetaType contentMetaType) NN_NOEXCEPT NN_OVERRIDE;
        ncm::ContentMetaKey m_Key;
        ncm::FileInstallTaskData m_Data;
    };
}}}
