﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/nim/srv/nim_EciAccessor.h>
#include <nn/nim/srv/nim_SimpleDataStore.h>
#include <nn/os/os_Mutex.h>

namespace nn { namespace nim { namespace srv {

    struct DeviceAccountInfo
    {
        DeviceAccountId id;
        DeviceAccountToken token;
    };

    class DeviceAccountStore : public SimpleDataStore<DeviceAccountInfo>
    {
    public:
        DeviceAccountStore() NN_NOEXCEPT : m_DataMutex(false) {}

        Result Save(const DeviceAccountInfo& info) NN_NOEXCEPT;
        Result Clear() NN_NOEXCEPT;
        Result Get(DeviceAccountInfo* outValue) NN_NOEXCEPT;

    private:
        os::Mutex m_DataMutex;
    };

}}}
