﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/err/err_Types.h>
#include <nn/nim/nim_ShopServiceAccessTypes.h>
#include <nn/nn_BitTypes.h>
#include <nn/nn_Result.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/sf/sf_Types.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace nim { namespace detail { // NOLINT(whitespace/braces)

class IShopServiceAccessor;

class IShopServiceAccessServer;

class IShopServiceAccessServerInterface;

class IShopServiceAsync;

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IShopServiceAccessor, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IShopServiceAccessor)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateAsyncInterface, (::nn::sf::Out<::nn::sf::NativeHandle> outEventHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IShopServiceAsync>> outAsync, const ::nn::nim::ShopServiceAccessTypes::FixedParams& inFixedParams))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IShopServiceAccessor)

        ::nn::Result CreateAsyncInterface(::nn::sf::Out<::nn::sf::NativeHandle> outEventHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IShopServiceAsync>> outAsync, const ::nn::nim::ShopServiceAccessTypes::FixedParams& inFixedParams) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateAsyncInterface, (outEventHandle, outAsync, inFixedParams));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IShopServiceAccessor
    {
    public:
        nn::Result CreateAsyncInterface(nn::sf::Out<nn::sf::NativeHandle> outEventHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IShopServiceAsync>> outAsync, const nn::nim::ShopServiceAccessTypes::FixedParams& inFixedParams) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result CreateAsyncInterface(nn::sf::Out<nn::sf::NativeHandle> outEventHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IShopServiceAsync>> outAsync, const nn::nim::ShopServiceAccessTypes::FixedParams& inFixedParams) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::nim::detail::IShopServiceAccessor))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateAsyncInterface, (::nn::sf::Out<::nn::sf::NativeHandle> outEventHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IShopServiceAsync>> outAsync, const ::nn::nim::ShopServiceAccessTypes::FixedParams& inFixedParams))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateAsyncInterface, (outEventHandle, outAsync, inFixedParams));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::nim::detail::IShopServiceAccessor>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::nim::detail::IShopServiceAccessor))

    // nn::Result CreateAsyncInterface(nn::sf::Out<nn::sf::NativeHandle> outEventHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IShopServiceAsync>> outAsync, const nn::nim::ShopServiceAccessTypes::FixedParams& inFixedParams) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateAsyncInterface)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outAsync, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outAsync))

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(outEventHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (outEventHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(inFixedParams, (::nn::nim::ShopServiceAccessTypes::FixedParams), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (inFixedParams))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(32)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outEventHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outAsync), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(inFixedParams)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateAsyncInterface)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::nim::ShopServiceAccessTypes::FixedParams), 32, 8)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::nim::detail::IShopServiceAccessor, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::nim::detail::IShopServiceAccessor))

    // nn::Result CreateAsyncInterface(nn::sf::Out<nn::sf::NativeHandle> outEventHandle, nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IShopServiceAsync>> outAsync, const nn::nim::ShopServiceAccessTypes::FixedParams& inFixedParams) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateAsyncInterface, (::nn::sf::Out<::nn::sf::NativeHandle> outEventHandle, ::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IShopServiceAsync>> outAsync, const ::nn::nim::ShopServiceAccessTypes::FixedParams& inFixedParams))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateAsyncInterface)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outEventHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outAsync)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(inFixedParams)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateAsyncInterface)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::nim::detail::IShopServiceAccessor>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::nim::detail::IShopServiceAccessor))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateAsyncInterface)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(outEventHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::nim::detail::IShopServiceAsync>), outAsync)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateAsyncInterface)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(outEventHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outAsync),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(inFixedParams)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outAsync, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateAsyncInterface)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::nim::detail::IShopServiceAccessor))

namespace nn { namespace nim { namespace detail { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IShopServiceAccessServer, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IShopServiceAccessServer)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateAccessorInterface, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IShopServiceAccessor>> outValue, ::nn::nim::ShopServiceAccessTypes::Server inServer))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IShopServiceAccessServer)

        ::nn::Result CreateAccessorInterface(::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IShopServiceAccessor>> outValue, ::nn::nim::ShopServiceAccessTypes::Server inServer) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateAccessorInterface, (outValue, inServer));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IShopServiceAccessServer
    {
    public:
        nn::Result CreateAccessorInterface(nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IShopServiceAccessor>> outValue, nn::nim::ShopServiceAccessTypes::Server inServer) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result CreateAccessorInterface(nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IShopServiceAccessor>> outValue, nn::nim::ShopServiceAccessTypes::Server inServer) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::nim::detail::IShopServiceAccessServer))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateAccessorInterface, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IShopServiceAccessor>> outValue, ::nn::nim::ShopServiceAccessTypes::Server inServer))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateAccessorInterface, (outValue, inServer));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::nim::detail::IShopServiceAccessServer>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::nim::detail::IShopServiceAccessServer))

    // nn::Result CreateAccessorInterface(nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IShopServiceAccessor>> outValue, nn::nim::ShopServiceAccessTypes::Server inServer) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateAccessorInterface)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outValue, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(inServer, (::nn::nim::ShopServiceAccessTypes::Server), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (inServer))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(inServer)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateAccessorInterface)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::nim::ShopServiceAccessTypes::Server), 1, 1)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::nim::detail::IShopServiceAccessServer, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::nim::detail::IShopServiceAccessServer))

    // nn::Result CreateAccessorInterface(nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IShopServiceAccessor>> outValue, nn::nim::ShopServiceAccessTypes::Server inServer) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateAccessorInterface, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IShopServiceAccessor>> outValue, ::nn::nim::ShopServiceAccessTypes::Server inServer))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateAccessorInterface)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(inServer)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateAccessorInterface)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::nim::detail::IShopServiceAccessServer>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::nim::detail::IShopServiceAccessServer))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateAccessorInterface)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::nim::detail::IShopServiceAccessor>), outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateAccessorInterface)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(inServer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outValue, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateAccessorInterface)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::nim::detail::IShopServiceAccessServer))

namespace nn { namespace nim { namespace detail { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IShopServiceAccessServerInterface, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IShopServiceAccessServerInterface)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateServerInterface, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IShopServiceAccessServer>> outValue, ::nn::Bit64 clientProcessId, ::nn::sf::NativeHandle&& inTransferHandle, ::std::uint64_t inTransferTotalSize))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(RefreshDebugAvailability)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(ClearDebugResponse)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RegisterDebugResponse, (::nn::nim::ShopServiceAccessTypes::Server inKeyTarget, const ::nn::sf::InArray<char>& inKeyPath, const ::nn::sf::InArray<char>& inValueResponse, ::std::uint32_t inExpectResult, ::std::uint32_t inHappenedRate))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IShopServiceAccessServerInterface)

        ::nn::Result CreateServerInterface(::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IShopServiceAccessServer>> outValue, ::nn::Bit64 clientProcessId, ::nn::sf::NativeHandle&& inTransferHandle, ::std::uint64_t inTransferTotalSize) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateServerInterface, (outValue, clientProcessId, ::std::move(inTransferHandle), inTransferTotalSize));
        }

        ::nn::Result RefreshDebugAvailability() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(RefreshDebugAvailability);
        }

        ::nn::Result ClearDebugResponse() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(ClearDebugResponse);
        }

        ::nn::Result RegisterDebugResponse(::nn::nim::ShopServiceAccessTypes::Server inKeyTarget, const ::nn::sf::InArray<char>& inKeyPath, const ::nn::sf::InArray<char>& inValueResponse, ::std::uint32_t inExpectResult, ::std::uint32_t inHappenedRate) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RegisterDebugResponse, (inKeyTarget, inKeyPath, inValueResponse, inExpectResult, inHappenedRate));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IShopServiceAccessServerInterface
    {
    public:
        nn::Result CreateServerInterface(nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IShopServiceAccessServer>> outValue, nn::Bit64 clientProcessId, nn::sf::NativeHandle&& inTransferHandle, std::uint64_t inTransferTotalSize) NN_NOEXCEPT;
        nn::Result RefreshDebugAvailability() NN_NOEXCEPT;
        nn::Result ClearDebugResponse() NN_NOEXCEPT;
        nn::Result RegisterDebugResponse(nn::nim::ShopServiceAccessTypes::Server inKeyTarget, const nn::sf::InArray<char>& inKeyPath, const nn::sf::InArray<char>& inValueResponse, std::uint32_t inExpectResult, std::uint32_t inHappenedRate) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result CreateServerInterface(nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IShopServiceAccessServer>> outValue, nn::Bit64 clientProcessId, nn::sf::NativeHandle&& inTransferHandle, std::uint64_t inTransferTotalSize) NN_NOEXCEPT;
    nn::Result RefreshDebugAvailability() NN_NOEXCEPT;
    nn::Result ClearDebugResponse() NN_NOEXCEPT;
    nn::Result RegisterDebugResponse(nn::nim::ShopServiceAccessTypes::Server inKeyTarget, const nn::sf::InArray<char>& inKeyPath, const nn::sf::InArray<char>& inValueResponse, std::uint32_t inExpectResult, std::uint32_t inHappenedRate) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::nim::detail::IShopServiceAccessServerInterface))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateServerInterface, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IShopServiceAccessServer>> outValue, ::nn::Bit64 clientProcessId, ::nn::sf::NativeHandle&& inTransferHandle, ::std::uint64_t inTransferTotalSize))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateServerInterface, (outValue, clientProcessId, ::std::move(inTransferHandle), inTransferTotalSize));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(RefreshDebugAvailability)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(RefreshDebugAvailability);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ClearDebugResponse)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(ClearDebugResponse);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RegisterDebugResponse, (::nn::nim::ShopServiceAccessTypes::Server inKeyTarget, const ::nn::sf::InArray<char>& inKeyPath, const ::nn::sf::InArray<char>& inValueResponse, ::std::uint32_t inExpectResult, ::std::uint32_t inHappenedRate))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RegisterDebugResponse, (inKeyTarget, inKeyPath, inValueResponse, inExpectResult, inHappenedRate));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::nim::detail::IShopServiceAccessServerInterface>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::nim::detail::IShopServiceAccessServerInterface))

    // nn::Result CreateServerInterface(nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IShopServiceAccessServer>> outValue, nn::Bit64 clientProcessId, nn::sf::NativeHandle&& inTransferHandle, std::uint64_t inTransferTotalSize) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateServerInterface)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_PROCESS_ID_ENABLE()

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFO(outValue, 0, 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_OBJECT_INFOS_END(1, (outValue))

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFO(inTransferHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS_END(1, (inTransferHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(clientProcessId, (::nn::Bit64), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(inTransferTotalSize, (::std::uint64_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (clientProcessId, inTransferTotalSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(clientProcessId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(inTransferHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(inTransferTotalSize)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateServerInterface)

    // nn::Result RefreshDebugAvailability() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RefreshDebugAvailability)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RefreshDebugAvailability)

    // nn::Result ClearDebugResponse() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ClearDebugResponse)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ClearDebugResponse)

    // nn::Result RegisterDebugResponse(nn::nim::ShopServiceAccessTypes::Server inKeyTarget, const nn::sf::InArray<char>& inKeyPath, const nn::sf::InArray<char>& inValueResponse, std::uint32_t inExpectResult, std::uint32_t inHappenedRate) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RegisterDebugResponse)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(inKeyPath, 0, (const ::nn::sf::InArray<char>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(inValueResponse, 1, (const ::nn::sf::InArray<char>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (inKeyPath, inValueResponse))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(inKeyTarget, (::nn::nim::ShopServiceAccessTypes::Server), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(inExpectResult, (::std::uint32_t), 4)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(inHappenedRate, (::std::uint32_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (inKeyTarget, inExpectResult, inHappenedRate))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(12)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(inKeyTarget), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(inKeyPath), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(inValueResponse), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(inExpectResult), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(inHappenedRate)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RegisterDebugResponse)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::nim::ShopServiceAccessTypes::Server), 1, 1)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::nim::detail::IShopServiceAccessServerInterface, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::nim::detail::IShopServiceAccessServerInterface))

    // nn::Result CreateServerInterface(nn::sf::Out<nn::sf::SharedPointer<nn::nim::detail::IShopServiceAccessServer>> outValue, nn::Bit64 clientProcessId, nn::sf::NativeHandle&& inTransferHandle, std::uint64_t inTransferTotalSize) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateServerInterface, (::nn::sf::Out<::nn::sf::SharedPointer<::nn::nim::detail::IShopServiceAccessServer>> outValue, ::nn::Bit64 clientProcessId, ::nn::sf::NativeHandle&& inTransferHandle, ::std::uint64_t inTransferTotalSize))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateServerInterface)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(clientProcessId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(inTransferHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(inTransferTotalSize)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateServerInterface)
    }

    // nn::Result RefreshDebugAvailability() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(RefreshDebugAvailability)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RefreshDebugAvailability)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RefreshDebugAvailability)
    }

    // nn::Result ClearDebugResponse() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ClearDebugResponse)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ClearDebugResponse)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ClearDebugResponse)
    }

    // nn::Result RegisterDebugResponse(nn::nim::ShopServiceAccessTypes::Server inKeyTarget, const nn::sf::InArray<char>& inKeyPath, const nn::sf::InArray<char>& inValueResponse, std::uint32_t inExpectResult, std::uint32_t inHappenedRate) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RegisterDebugResponse, (::nn::nim::ShopServiceAccessTypes::Server inKeyTarget, const ::nn::sf::InArray<char>& inKeyPath, const ::nn::sf::InArray<char>& inValueResponse, ::std::uint32_t inExpectResult, ::std::uint32_t inHappenedRate))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RegisterDebugResponse)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(inKeyTarget)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(inKeyPath)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(inValueResponse)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(inExpectResult)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(inHappenedRate)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RegisterDebugResponse)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::nim::detail::IShopServiceAccessServerInterface>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::nim::detail::IShopServiceAccessServerInterface))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateServerInterface)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLE(inTransferHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_DEFINE_OUT_OBJECT((::nn::sf::SharedPointer<::nn::nim::detail::IShopServiceAccessServer>), outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OVERWRITE_IN_PROCESS_ID(clientProcessId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateServerInterface)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_OBJECT(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(clientProcessId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_NATIVE_HANDLE(inTransferHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(inTransferTotalSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_SET_OUT_OBJECT(outValue, 0)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RefreshDebugAvailability)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RefreshDebugAvailability)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ClearDebugResponse)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ClearDebugResponse)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RegisterDebugResponse)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(inKeyPath)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(inValueResponse)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RegisterDebugResponse)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(inKeyTarget),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(inKeyPath),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(inValueResponse),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(inExpectResult),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(inHappenedRate)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateServerInterface)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RefreshDebugAvailability)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ClearDebugResponse)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RegisterDebugResponse)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::nim::detail::IShopServiceAccessServerInterface))

namespace nn { namespace nim { namespace detail { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IShopServiceAsync, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IShopServiceAsync)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(Cancel)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetSize, (::nn::sf::Out<::std::uint64_t> outValue))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(Read, (::nn::sf::Out<::std::uint64_t> outValue, ::std::uint64_t offset, const ::nn::sf::OutBuffer& outBuffer))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetErrorCode, (::nn::sf::Out<::nn::err::ErrorCode> outCode))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(Request)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(Prepare, (const ::nn::sf::InArray<char>& inPath, const ::nn::sf::InArray<char>& inPost))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IShopServiceAsync)

        ::nn::Result Cancel() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(Cancel);
        }

        ::nn::Result GetSize(::nn::sf::Out<::std::uint64_t> outValue) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetSize, (outValue));
        }

        ::nn::Result Read(::nn::sf::Out<::std::uint64_t> outValue, ::std::uint64_t offset, const ::nn::sf::OutBuffer& outBuffer) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(Read, (outValue, offset, outBuffer));
        }

        ::nn::Result GetErrorCode(::nn::sf::Out<::nn::err::ErrorCode> outCode) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetErrorCode, (outCode));
        }

        ::nn::Result Request() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(Request);
        }

        ::nn::Result Prepare(const ::nn::sf::InArray<char>& inPath, const ::nn::sf::InArray<char>& inPost) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(Prepare, (inPath, inPost));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IShopServiceAsync
    {
    public:
        nn::Result Cancel() NN_NOEXCEPT;
        nn::Result GetSize(nn::sf::Out<std::uint64_t> outValue) NN_NOEXCEPT;
        nn::Result Read(nn::sf::Out<std::uint64_t> outValue, std::uint64_t offset, const nn::sf::OutBuffer& outBuffer) NN_NOEXCEPT;
        nn::Result GetErrorCode(nn::sf::Out<nn::err::ErrorCode> outCode) NN_NOEXCEPT;
        nn::Result Request() NN_NOEXCEPT;
        nn::Result Prepare(const nn::sf::InArray<char>& inPath, const nn::sf::InArray<char>& inPost) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result Cancel() NN_NOEXCEPT;
    nn::Result GetSize(nn::sf::Out<std::uint64_t> outValue) NN_NOEXCEPT;
    nn::Result Read(nn::sf::Out<std::uint64_t> outValue, std::uint64_t offset, const nn::sf::OutBuffer& outBuffer) NN_NOEXCEPT;
    nn::Result GetErrorCode(nn::sf::Out<nn::err::ErrorCode> outCode) NN_NOEXCEPT;
    nn::Result Request() NN_NOEXCEPT;
    nn::Result Prepare(const nn::sf::InArray<char>& inPath, const nn::sf::InArray<char>& inPost) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::nim::detail::IShopServiceAsync))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(Cancel)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(Cancel);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSize, (::nn::sf::Out<::std::uint64_t> outValue))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetSize, (outValue));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Read, (::nn::sf::Out<::std::uint64_t> outValue, ::std::uint64_t offset, const ::nn::sf::OutBuffer& outBuffer))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(Read, (outValue, offset, outBuffer));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetErrorCode, (::nn::sf::Out<::nn::err::ErrorCode> outCode))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetErrorCode, (outCode));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(Request)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(Request);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Prepare, (const ::nn::sf::InArray<char>& inPath, const ::nn::sf::InArray<char>& inPost))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(Prepare, (inPath, inPost));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::nim::detail::IShopServiceAsync>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::nim::detail::IShopServiceAsync))

    // nn::Result Cancel() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Cancel)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Cancel)

    // nn::Result GetSize(nn::sf::Out<std::uint64_t> outValue) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetSize)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetSize)

    // nn::Result Read(nn::sf::Out<std::uint64_t> outValue, std::uint64_t offset, const nn::sf::OutBuffer& outBuffer) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Read)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outBuffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(offset, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (offset))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outValue, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outValue))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outValue), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(offset), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outBuffer)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Read)

    // nn::Result GetErrorCode(nn::sf::Out<nn::err::ErrorCode> outCode) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetErrorCode)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(outCode, (::nn::err::ErrorCode), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (outCode))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outCode)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetErrorCode)

    // nn::Result Request() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Request)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Request)

    // nn::Result Prepare(const nn::sf::InArray<char>& inPath, const nn::sf::InArray<char>& inPost) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Prepare)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(5)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(inPath, 0, (const ::nn::sf::InArray<char>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(inPost, 1, (const ::nn::sf::InArray<char>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (inPath, inPost))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(inPath), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(inPost)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Prepare)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::err::ErrorCode), 8, 4)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::nim::detail::IShopServiceAsync, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::nim::detail::IShopServiceAsync))

    // nn::Result Cancel() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(Cancel)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Cancel)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Cancel)
    }

    // nn::Result GetSize(nn::sf::Out<std::uint64_t> outValue) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSize, (::nn::sf::Out<::std::uint64_t> outValue))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetSize)
    }

    // nn::Result Read(nn::sf::Out<std::uint64_t> outValue, std::uint64_t offset, const nn::sf::OutBuffer& outBuffer) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Read, (::nn::sf::Out<::std::uint64_t> outValue, ::std::uint64_t offset, const ::nn::sf::OutBuffer& outBuffer))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Read)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outValue)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(offset)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outBuffer)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Read)
    }

    // nn::Result GetErrorCode(nn::sf::Out<nn::err::ErrorCode> outCode) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetErrorCode, (::nn::sf::Out<::nn::err::ErrorCode> outCode))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetErrorCode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outCode)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetErrorCode)
    }

    // nn::Result Request() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(Request)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Request)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Request)
    }

    // nn::Result Prepare(const nn::sf::InArray<char>& inPath, const nn::sf::InArray<char>& inPost) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Prepare, (const ::nn::sf::InArray<char>& inPath, const ::nn::sf::InArray<char>& inPost))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Prepare)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(inPath)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(inPost)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Prepare)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::nim::detail::IShopServiceAsync>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::nim::detail::IShopServiceAsync))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Cancel)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Cancel)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetSize)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Read)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Read)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outValue),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(offset),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outBuffer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetErrorCode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetErrorCode)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(outCode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Request)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Request)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Prepare)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(inPath)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(inPost)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Prepare)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(inPath),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(inPost)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Cancel)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Read)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetErrorCode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Request)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Prepare)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::nim::detail::IShopServiceAsync))
