﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nifm/nifm_Common.h>

#include <nn/nifm/nifm_TypesNetworkInterface.h>
#include <nn/nifm/nifm_TypesLinkLevel.h>

namespace nn
{
namespace nifm
{

/**
 * @brief インターネット疎通確認の状態を表します。
 */
enum InternetAvailability
{
    InternetAvailability_Invalid,        //!< 不正もしくはインターネット接続以外の接続

    InternetAvailability_LocalAreaOnly,  //!< LAN 限定（後方互換用であり、この状態には遷移しない）
    InternetAvailability_InProgress,     //!< 確認中
    InternetAvailability_NotConfirmed,   //!< 未確認もしくは確認したが失敗した
    InternetAvailability_Confirmed,      //!< 確認済み

    InternetAvailability_Count
};

/**
 * @brief インターネット通信接続の情報を表す構造体です。
 */
struct InternetConnectionStatus
{
    NetworkInterfaceType networkInterfaceType;  //!< リンク層の種類
    LinkLevel linkLevel;                        //!< リンクレベル
    InternetAvailability internetAvailability;  //!< インターネット疎通確認の状態
};

}
}

