﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nifm/detail/core/profile/nifm_TemporaryNetworkProfile.h>

#include <nn/nifm/detail/service/nifm_Capability.h>
#include <nn/nifm/detail/service/nifm_INifmService.sfdl.h>

namespace nn
{
namespace nifm
{
namespace detail
{

class NetworkProfileManager;

class TemporaryNetworkProfileImpl
{
    NN_DISALLOW_COPY(TemporaryNetworkProfileImpl);
    NN_DISALLOW_MOVE(TemporaryNetworkProfileImpl);

private:
    NetworkProfileManager* m_pNetworkProfileManager;
    nn::util::Uuid m_Id;
    Capability m_Capability;

public:
    explicit TemporaryNetworkProfileImpl(NetworkProfileManager* pNetworkProfileManager, const nn::util::Uuid& id, const Capability& capability) NN_NOEXCEPT
        : m_pNetworkProfileManager(pNetworkProfileManager),
          m_Id(id),
          m_Capability(capability)
    {
    }

    ~TemporaryNetworkProfileImpl() NN_NOEXCEPT;

    const nn::util::Uuid& GetId() NN_NOEXCEPT
    {
        return m_Id;
    }

    Result Update( nn::sf::Out<nn::util::Uuid> outNetworkProfileId, const sf::NetworkProfileData& networkProfileData ) NN_NOEXCEPT;

    Result PersistOld(nn::sf::Out<nn::util::Uuid> newId, const nn::util::Uuid id) NN_NOEXCEPT; // Deprecated
    Result Persist(nn::sf::Out<nn::util::Uuid> newId) NN_NOEXCEPT;
};

}
}
}
