﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nifm/detail/nifm_CommonDetail.h>

#include <nn/nifm/detail/core/nifm_RequestManager.h>
#include <nn/nifm/detail/core/profile/nifm_NetworkProfileManager.h>
#include <nn/nifm/detail/core/nifm_ConnectionSelector.h>
#include <nn/nifm/detail/core/nifm_DispatchLoop.h>
#include <nn/nifm/detail/core/networkInterface/nifm_WirelessInterface.h>
#include <nn/nifm/detail/core/networkInterface/nifm_EthernetInterfaceManager.h>
#include <nn/nifm/detail/core/nifm_PowerStateCoordinator.h>
#include <nn/nifm/detail/service/nifm_HipcServerManager.h>


namespace nn
{
namespace nifm
{
namespace detail
{

class ServiceProvider
{
    friend class ServiceProviderClient;
    friend class GeneralServiceInterface;
    friend class HipcServerManager;

private:
    class GeneralArranger
    {
    public:
        GeneralArranger() NN_NOEXCEPT;
        ~GeneralArranger() NN_NOEXCEPT;
    };

private:
    // ServiceProvider のメンバになるクラスは、コンストラクタの引数でポインタを与えられても
    // コンストラクタ内では、変数への格納以外、ポインタに対して操作をおこなってはいけない
    GeneralArranger m_GeneralArranger;

    NetworkProfileManager m_NetworkProfileManager;

    ConnectionSelector m_ConnectionSelector;
    WirelessInterface m_WirelessInterface;
    EthernetInterfaceManager m_EthernetInterfaceManager;
    RequestManager m_RequestManager;
    PowerStateCoordinator m_PowerStateCoordinator;
    DispatchLoop m_DispatchLoop;

    HipcServerManager m_HipcServerManager;

    bool m_IsWirelessCommunicationEnabled;

public:
    ServiceProvider() NN_NOEXCEPT;
    ~ServiceProvider() NN_NOEXCEPT;

    nn::Result Start() NN_NOEXCEPT;
};

}
}
}
