﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nifm/detail/nifm_CommonDetail.h>

#include <nn/nifm/detail/service/nifm_INifmService.sfdl.h>
#include <nn/nifm/detail/service/nifm_Capability.h>
#include <nn/nifm/detail/util/nifm_SignalObject.h>
#include <nn/nifm/nifm_TypesClientManagement.h>
#include <nn/nifm/nifm_TypesScan.h>

#include <nn/os/os_SystemEvent.h>


namespace nn
{
namespace nifm
{
namespace detail
{

class ConnectionSelector;

class ScanRequestImpl
{
    NN_DISALLOW_COPY(ScanRequestImpl);
    NN_DISALLOW_MOVE(ScanRequestImpl);

private:
    ConnectionSelector* m_pConnectionSelector;
    const Capability& m_Capability;

    uint32_t m_ScanCounter;
    class SystemEventHolder : public ISignalObject
    {
    private:
        nn::os::SystemEvent m_SystemEvent;
        bool m_IsToBeSignaled;

    public:
        SystemEventHolder() NN_NOEXCEPT;
        ~SystemEventHolder() NN_NOEXCEPT;

        void Signal() NN_NOEXCEPT NN_OVERRIDE;

        void SetToBeSignaled(bool isToBeSignaled) NN_NOEXCEPT;

        nn::os::SystemEvent& Get() NN_NOEXCEPT;
        const nn::os::SystemEvent& Get() const NN_NOEXCEPT;
    } m_SystemEventHolder;
    SignalListItem m_SignalListItem;

    int m_ScanChannelNum;
    int16_t m_ScanChannels[WirelessChannelsCountMax];

public:
    ScanRequestImpl(ConnectionSelector* pConnectionSelector, const Capability& capability) NN_NOEXCEPT;
    ~ScanRequestImpl() NN_NOEXCEPT;

    nn::Result Submit() NN_NOEXCEPT;

    nn::Result IsProcessing(nn::sf::Out<bool> outIsProcessing) const NN_NOEXCEPT;

    nn::Result GetSystemEventReadableHandle(nn::sf::Out<nn::sf::NativeHandle> systemEventReadableHandle) NN_NOEXCEPT;

    nn::Result GetResult() const NN_NOEXCEPT;

    bool IsProcessing() const NN_NOEXCEPT;
    nn::os::NativeHandle GetSystemEventReadableHandle() NN_NOEXCEPT;

    //
    nn::Result SetChannels(nn::sf::InArray<int16_t> scanChannelArray) NN_NOEXCEPT;
};

}
}
}
