﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nifm/detail/nifm_CommonDetail.h>

#include <nn/nifm/detail/service/nifm_INifmService.sfdl.h>

namespace nn
{
namespace nifm
{

struct NetworkProfileData;

namespace detail
{

/**
* @brief テンポラリ接続設定を表します。
*/
class TemporaryNetworkProfileClient
{
    NN_DISALLOW_COPY(TemporaryNetworkProfileClient);
    NN_DISALLOW_MOVE(TemporaryNetworkProfileClient);

private:
    nn::sf::SharedPointer<detail::INetworkProfile> m_pINetworkProfile;
    nn::util::Uuid m_Id;

public:
    explicit TemporaryNetworkProfileClient(const NetworkProfileData& networkProfileData) NN_NOEXCEPT;
    ~TemporaryNetworkProfileClient() NN_NOEXCEPT;

    const nn::util::Uuid& GetId() const NN_NOEXCEPT;

    Result Update(const NetworkProfileData& networkProfileData) NN_NOEXCEPT;

    Result Persist() NN_NOEXCEPT;
};

}
}
}

