﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nifm/nifm_Common.h>

#include <nn/nifm/nifm_TypesTelemetry.h>

#include <nn/os/os_SystemEvent.h>
#include <nn/util/util_Optional.h>

namespace nn
{
namespace nifm
{
namespace detail
{

class TelemetryContext
{
private:
    nn::os::SystemEvent m_SystemEvent;

    Result m_Result;
    nn::util::optional<NetworkProfileData> m_NetworkProfileData;
    nn::util::optional<AccessPointData> m_AccessPointData;
    nn::util::optional<MacAddress> m_WirelessMacAddress;
    nn::util::optional<MacAddress> m_EthernetMacAddress;
    nn::util::optional<IpAddressSetting> m_IpAddressSetting;
    nn::util::optional<DnsSetting> m_DnsSetting;
    nn::util::optional<SsidListVersion> m_SsidListVersion;
    nn::util::optional<AdditionalInfo> m_AdditionalInfo;

public:
    TelemetryContext() NN_NOEXCEPT;
    ~TelemetryContext() NN_NOEXCEPT;

    void SetResult(Result result) NN_NOEXCEPT;
    void SetNetworkProfile(const nn::util::optional<NetworkProfileData>& networkProfileData) NN_NOEXCEPT;
    void SetAccessPoint(const nn::util::optional<AccessPointData>& accessPointData) NN_NOEXCEPT;
    void SetWirelessMacAddress(const nn::util::optional<MacAddress>& macAddress) NN_NOEXCEPT;
    void SetEthernetMacAddress(const nn::util::optional<MacAddress>& macAddress) NN_NOEXCEPT;
    void SetIpConfig(const nn::util::optional<IpAddressSetting>& ipAddressSetting, const nn::util::optional<DnsSetting>& dnsSetting) NN_NOEXCEPT;
    void SetSsidListVersion(const nn::util::optional<SsidListVersion>& ssidListVersion) NN_NOEXCEPT;
    void SetAdditionalInfo(const nn::util::optional<AdditionalInfo>& additionalInfo) NN_NOEXCEPT;

    void Signal() NN_NOEXCEPT;

    nn::os::NativeHandle GetSystemEventReadableHandle() NN_NOEXCEPT;

    void GetTelemetryInfo(TelemetryInfo* pOutTelemetryInfo) NN_NOEXCEPT;
};

}
}
}
